////////////////////////////////////////////////////////////////////////////////
// Name:         XmasLed                                                      //
// Platform:     Arduino Uno                                                  //
// Created by:   HARB rboek2@gmail.com december 2019 GPL copyrights           //
// http://robotigs.nl/robotigs/includes/parts_header.php?idpart=97            //
// Let the Xmas lights shine and twinkle.                                     //
// - Uses PWM to drive multiple Xmas gadgets.                                 //
// - Push reset button to select next program via EEPROM.                     //
// Maximum of fun with minimum of hardware.                                   //
// Blinks at start the program number times, so program 2 gives 2 blinks.     //
////////////////////////////////////////////////////////////////////////////////



// SET PRECOMPILER OPTIONS *****************************************************
// Initialse conditional compiling, uncomment to include, comment to exclude ---

// Define precompiler variables -----------------(Runs faster & doesn`t use RAM)

// Define PINS -----------------------------------------------------------------
  #define ledXmas     9            //White LED Christmas window chain, needs PWM
  #define treeXmas   10              //White LED Christmas tree round, needs PWM

// Define the needed header files for the precompiler, no charge if not used ---
  #include <EEPROM.h>               //Needed to read or write settings in EEPROM
             // http://robotigs.nl/robotigs/includes/parts_header.php?idpart=312
//END OF PRECOMPILER OPTIONS ---------------------------------------------------

  //Define EEPROM variables ----------------------------------------------------
  int    lightProg        = 1;    //lightProg current program 1-255 What to show
  //Define DATABASE VARIABLES --------------------------------------------------

  //Define VARIABLES -----------------------------------------------------------
  bool ledOnBoardVal      = LOW; //You choose HIGH-on or LOW-off for LED_BUILTIN
  unsigned int maxPWM     = 230;           //Christmas LEDs output max PWM value
  unsigned int milliSecs  = 10;      //Christmas LEDs fader output counter timer
  unsigned int BlinkTimer = 3;     //Christmas LEDs blinker output counter timer
  unsigned int BlinkTimes = 60;//Christmas LEDs blinker number of on on switches
  unsigned int CntrTmp1   = 0;                    //To be used in any subroutine
  unsigned int CntrTmp2   = 0;                    //To be used in any subroutine
  unsigned int dimAround  = 229;                      //Must be less then maxPWM
//END OF PRECOMPILER OPTIONS ---------------------------------------------------


void setup() {
  disable_jtag();              //Disable jtag to free port C, enabled by default
  Serial.begin(57600);  //Nothing more needed for the Serial Monitor to function
  pinMode(LED_BUILTIN, OUTPUT);  //Arduino boards contain an onboard LED_BUILTIN
  pinMode(ledXmas, OUTPUT);            //White LED Christmas window chain on PWM
  pinMode(treeXmas, OUTPUT);             //White LED Christmas tree round on PWM

  lightProg  = EEPROM.read(1);    //lightProg current program 1-255 What to show
  lightProg++;                                   //Set to the next light program
  if (lightProg > 4){          //We don`t have more programs, be creativ and add
    lightProg = 1;                                 //Reset to the first programm
  }      //Store in EEPROM so we also know where we are after reset or power off
  EEPROM.write(1, lightProg);     //lightProg current program 1-255 What to show
  blinkXtimes();             //Let all LEDs blink for lightProg times BLINK LEDS
} //End of setup




void loop() {                                //KEEP ON RUNNING THIS LOOP FOREVER
  switch (lightProg) {                           //Go to the according procedure

    case 1: 
      prog1();                           //Shows the Christmas LED chain just on
    break;

    case 2: 
      prog2();                          //Shows the Christmas LED chain blinking
    break;

    case 3: 
      prog3();                          //Shows the Christmas LED chain blinking
    break;

    case 4: 
      prog4();                                      //Inside on, outside dimming
    break;
    
  } //End of switch (command)                      Go to the according procedure
} //End of void loop()                       //KEEP ON RUNNING THIS LOOP FOREVER
//345678911234567892123456789312345678941234567895123456789612345678971234567898





void prog1(void){                        //Shows the Christmas LED chain just on
  analogWrite(ledXmas, maxPWM);                                        //LEDs on
  analogWrite(treeXmas, maxPWM);                                       //LEDs on
} //Exit prog1 -----------------------------------------------------------------

void prog2(void){                       //Shows the Christmas LED chain blinking
  XmasLEDs2();                          //Shows the Christmas LED chain blinking
  XmasLEDs1();        //Shows the Christmas LED chain one time fading out and in
} //Exit prog2 -----------------------------------------------------------------

void prog3(void){                       //Shows the Christmas LED chain blinking
  analogWrite(ledXmas, maxPWM);                                       //Chain on
  digitalWrite(treeXmas, 0);                                          //Tree off
  delay (50000);                                       //Test your patience here
  digitalWrite(ledXmas, 0);                                          //Chain off
  analogWrite(treeXmas, maxPWM);                                       //LEDs on
  delay (50000);                                       //Test your patience here
} //Exit prog3 -----------------------------------------------------------------


void prog4(void){               //Shows the tree and chain on, but a bit dimming
  XmasLEDs4();                  //Shows the tree and chain on, but a bit dimming
} //Exit prog1 -----------------------------------------------------------------



void XmasLEDs1(void){ //Shows the Christmas LED chain one time fading out and in
  CntrTmp1 = maxPWM;
  while (CntrTmp1 > 1){                            //Start dimming the LED chain
    analogWrite(ledXmas, CntrTmp1);     //Set Christmas LED to desired PWM value
    CntrTmp1--;                                            //Dim the LED 1 point
    delay (milliSecs);                                 //Test your patience here
  }                                               //End of dimming the LED chain
  while (CntrTmp1 < maxPWM){                     //Start fading in the LED chain
    analogWrite(ledXmas, CntrTmp1);     //Set Christmas LED to desired PWM value
    CntrTmp1++;                                            //Dim the LED 1 point
    delay (milliSecs);                                 //Test your patience here
  }                                               //End of dimming the LED chain
} //Exit XmasLEDs1 -------------------------------------------------------------




void XmasLEDs2(void){                   //Shows the Christmas LED chain blinking
  CntrTmp2 = BlinkTimes;
  while (CntrTmp2 > 0){
    CntrTmp1 = BlinkTimer;
    while (CntrTmp1 > 1){                              //Switch on the LED chain
      analogWrite(ledXmas, maxPWM);     //Set Christmas LED to desired PWM value
      analogWrite(treeXmas, maxPWM);    //Set Christmas LED to desired PWM value
      CntrTmp1--;                                   //Decrease the timer 1 point
      delay (milliSecs);                               //Test your patience here
    }                                             //End of dimming the LED chain
    while (CntrTmp1 < BlinkTimer){                    //Switch off the LED chain
      analogWrite(ledXmas, 0);          //Set Christmas LED to desired PWM value
      analogWrite(treeXmas, 0);         //Set Christmas LED to desired PWM value
      CntrTmp1++;                                   //Increase the timer 1 point
      delay (milliSecs);                               //Test your patience here
    }                                       //End of single switch the LED chain
    CntrTmp2--;                      //Decrease the number of times with 1 point
  }                                  //End of switching the LED chain on and off
} //Exit XmasLEDs2 -------------------------------------------------------------



 
void XmasLEDs4(void){           //Shows the tree and chain on, but a bit dimming
  CntrTmp1 = maxPWM;
  CntrTmp2 = maxPWM - dimAround;
  analogWrite(ledXmas, CntrTmp1);                                      //LEDs on
  analogWrite(treeXmas, CntrTmp2);                                     //LEDs on

  while (CntrTmp1 > (maxPWM-dimAround)){
    CntrTmp1--;                                                  //Dim the light
    CntrTmp2++; 
    analogWrite(ledXmas, CntrTmp1);     //Set Christmas LED to desired PWM value
    analogWrite(treeXmas, CntrTmp2);    //Set Christmas LED to desired PWM value
    delay (milliSecs);                                 //Test your patience here
  }                                               //End of dimming the LED chain
    
  while (CntrTmp2 > (maxPWM-dimAround)){
    CntrTmp1++;                                                  //Dim the light
    CntrTmp2--; 
    analogWrite(ledXmas, CntrTmp1);     //Set Christmas LED to desired PWM value
    analogWrite(treeXmas, CntrTmp2);    //Set Christmas LED to desired PWM value
    delay (milliSecs);                                 //Test your patience here
  }                                         //End of single switch the LED chain
} //Exit XmasLEDs4 -------------------------------------------------------------




void blinkXtimes(void){      //Let all LEDs blink for lightProg times BLINK LEDS
  CntrTmp1 = 1;                                      //Always start at program 1
  while (CntrTmp1 <= lightProg) { //lightProg current program 1-255 What to show
    CntrTmp1++;                                       //Set for the next program
    analogWrite(ledXmas, maxPWM);                                      //LEDs on
    analogWrite(treeXmas, maxPWM);                                     //LEDs on
    delay (500);                                                     //Just wait
    digitalWrite(ledXmas, 0);                                         //LEDs off
    digitalWrite(treeXmas, 0);                                        //LEDs off
    delay (500);                                     //Just wait between blinks
  } //End of while (CntrTmp1 <= lightProg)     //All the blinking needed is done
   delay (2000);                                       //Test your patience here
} //Exit blinkXtimes -----------------------------------------------------------




void toggle_ledOnBoard(void){ //Toggles the LED_BUILTIN on-board LED on or off *
  ledOnBoardVal = !ledOnBoardVal;                                 //Toggle value
  digitalWrite(LED_BUILTIN, ledOnBoardVal);     //Set Arduino boards onboard LED
} //Exit toggle_ledBin ---------------------------------------------------------




void disable_jtag(void) { //Disable jtag to free port C, enabled by default ****
#if defined(JTD)                           //Not all AVR controller include jtag
  MCUCR |= ( 1 << JTD );                                //Write twice to disable
  MCUCR |= ( 1 << JTD );                                       //So stutter once
#endif                                            //End of conditional compiling
} //Exit jtag_disable ----------------------------------------------------------


////////////////////////////////////////////////////////////////////////////////
// PIN ALLOCATIONS TABLE ARDUINO MEGA 2560                                    //
// Board  -Atmel- PIN - IDE - Function          - External Connection    FUNC //
//                                                                            //
// CONNECTIONS RAILS TOP LEFT: DIGITAL PWM<~> ******************************* //
//? SCL   -  28 - PC5 -19/A5- ADC5/SCL/PCINT13  -                         TWI //
//? SDA   -  27 - PC4 -18/A4- ADC4/SDA/PCINT12  -                         TWI //
// AREF   -  31 - REF -     - AREF              -                         REF //
// GND    -  32 - GND -     - GND               -                         GND //
// 13 PWM -  26 - PB7 -  13 - OC0A/OC1C/PCINT17 - LED Arduino LED_BUILTIN PWM //
// 12 PWM -  18 - PB6 -  12 - OC1B/PCINT16      -                         PWM //
// 11 PWM -  17 - PB3 -  11 - MOSI/OC2A/PCINT3  -                         PWM //
// 10 PWM -  16 - PB2 -  10 - SS/OC1B/PCINT2    - Christmas LED tree      PWM //
//  9 PWM -  15 - PB1 -   9 - OC1A/PCINT1       - Christmas LED chain     PWM //
//  8 PWM -  14 - PB0 -   8 - PCINT0/CLK0/ICP1  -                         DIO //
//                                                                            //
// CONNECTIONS RAILS TOP MIDDLE: DIGITAL PWM<~> ***************************** //
//  7 PWM -  13 - PD7 -   7 - PCINT23/AIN1      -                         PWM //
//  6 PWM -  12 - PD6 -   6 - PCINT22/OCA0/AIN0 -                         PWM //
//  5 PWM -  11 - PD5 -   5 - PCINT21/OC0B/T1   -                         PWM //
//  4 PWM -   6 - PD4 -   4 - PCINT20/XCK/T0    -                         PWM //
//  3 PWM -   5 - PD3 -   3 - PCINT19/OC2B/INT1 -                         PWM //
//  2 PWM -   4 - PD2 -   2 - PCINT18/INT0      -                         INT //
//  1 TX0 -   3 - PD1 -   1 - PCINT17/TXD       - Serial monitor          TX0 //
//  0 RX0 -   2 - PD0 -   0 - PCINT16/RCD       - Serial Monitor          RC0 //
//                                                                            //
// CONNECTIONS RAILS TOP RIGHT: DIGITAL PWM<~> ****************************** //
// 14 TX3 -  13 - PD7 -   7 - PCINT23/AIN1      -                         DIO //
// 15 RX3 -  12 - PD6 -   6 - PCINT22/OCA0/AIN0 -                         PWM //
// 16 TX2 -  11 - PD5 -   5 - PCINT21/OC0B/T1   -                         TX2 //
// 17 RX2 -   6 - PD4 -   4 - PCINT20/XCK/T0    -                         RX2 //
// 18 TX1 -   5 - PD3 -   3 - PCINT19/OC2B/INT1 -                         INT //
// 19 RX1 -   4 - PD2 -   2 - PCINT18/INT0      -                         INT //
// 20 SDA -   3 - PD1 -   1 - PCINT17/TXD       -                         SDA //
// 21 SCL -   2 - PD0 -   0 - PCINT16/RCD       -                         SCL //
//                                                                            //
// CONNECTIONS RAILS BOTTOM LEFT: POWER ************************************* //
// 5V    -   7 - VCC -     - VCC               -                          VCC //
// RES   -   1 - RES -     - PCINT14/RESET     -                          RES //
// 3.3V  -     -     -     -                   -                              //
// 5V    -     -     -     -                   -                              //
// GND   -     -     -     -                   -                              //
// GND   -     -     -     -                   -                              //
// Vin   -     -     -     -                   -                              //
//                                                                            //
// CONNECTIONS RAILS BOTTOM CENTER: ANALOG IN ******************************* //
// A0    -  23 - PC0 -A0/14- ADC0/PCINT8       -                          ADC //
// A1    -  24 - PC1 -A1/15- ADC1/PCINT9       -                          ADC //
// A2    -  25 - PC2 -A2/16- ADC2/PCINT10      -                          ADC //
// A3    -  26 - PC3 -A3/17- ADC3/PCINT12      -                          ADC //
// A4    -  27 - PC4 -A4/18- ADC4/SDA/PCINT12  -                          TWI //
// A5    -  28 - PC5 -A5/19- ADC5/SCL/PCINT13  -                          TWI //
// 20  = 44 = PD1 SDA/INT1         =                                      TWI //
// 21  = 43 = PD0 SCL/INT0         =                                      TWI //
////////////////////////////////////////////////////////////////////////////////
//345678911234567892123456789312345678941234567895123456789612345678971234567898
// EEPROM MEMORY MAP:                                                         //
// Start End  Number Description                                              //
// 0000  0000      1 Never use this memory location to be AVR compatible      //
////////////////////////////////////////////////////////////////////////////////
//345678911234567892123456789312345678941234567895123456789612345678971234567898
////////////////////////////////////////////////////////////////////////////////
// FUSES (can always be altered by using the STK500)                          //
// On-Chip Debug Enabled: off                            (OCDEN=0)            //
// JTAG Interface Enabled: off                           (JTAGEN=0)           //
// Preserve EEPROM mem through the Chip Erase cycle: On  (EESAVE = 0)         //
// Boot Flash section = 2048 words, Boot startaddr=$3800 (BOOTSZ=00)          //
// Boot Reset vector Enabled, default address=$0000      (BOOTSTR=0)          //
// CKOPT fuse (operation dependent of CKSEL fuses        (CKOPT=0)            //
// Brown-out detection level at VCC=2,7V;                (BODLEVEL=1)         //
// Ext. Cr/Res High Freq.; Start-up time: 16K CK + 64 ms (CKSEL=1111 SUT=11)  //
// LOCKBITS (are dangerous to change, since they cannot be reset)             //
// Mode 1: No memory lock features enabled                                    //
// Application Protect Mode 1: No lock on SPM and LPM in Application Section  //
// Boot Loader Protect Mode 1: No lock on SPM and LPM in Boot Loader Section  //
////////////////////////////////////////////////////////////////////////////////
