/* Copyright 2018 Dustmap.org. All rights reserved.
 *
 * This work is licensed under the terms of the MIT license.
 * For a copy, see <https://opensource.org/licenses/MIT>.
 */

  #include <SPI.h>
  #include <lmic.h>
  #include <hal/hal.h>
  #include "config.h"
  #include <DHT.h> //Needed for DHT22 and DHT11 Temperature and humidity sensors
             // http://robotigs.nl/robotigs/includes/parts_header.php?idpart=252

  const lmic_pinmap lmic_pins = {
    .nss = NSS_GPIO,
    .rxtx = LMIC_UNUSED_PIN,
    .rst = RESET_GPIO,
    .dio = {DIO0_GPIO, DIO1_GPIO, DIO2_GPIO},
  };

  float  hobbyAirTemp   = 0;              //Air temperature degree Celsius DHT22
  float  hobbyAirHum    = 0;                     //Air humidity percentage DHT22

  DHT dht(DHT22_PIN, DHTTYPE);                            //Initialize DHT22 sensor

  static osjob_t sendjob;

  static u1_t devEUI[8] = DEVEUI;
  void os_getDevEui (u1_t* buf) {
	  memcpy(buf, devEUI, 8);
  }
  static const u1_t PROGMEM appEUI[8] = APPEUI;
  void os_getArtEui (u1_t* buf) {
	  memcpy_P(buf, appEUI, 8);
  }

  static const u1_t PROGMEM appKey[16] = APPKEY;
  void os_getDevKey (u1_t* buf) {
	  memcpy_P(buf, appKey, 16);
  }


void setup() {
  Serial.begin(115200);
  Serial.println("Start setup");
  dht.begin();  
  os_init();     // LMIC init
  LMIC_reset(); // Reset the MAC state. Session and pending data transfers will be discarded.
  do_send(&sendjob);   // Start job (sending automatically starts OTAA too)
}



void loop() {
  os_runloop_once();
  hobbyAirTemp = dht.readTemperature();    //Read temperature as Celsius DHT22
  hobbyAirHum = dht.readHumidity();     //Reading takes 250 milliseconds DHT22
  Serial.print (" - DHT22 Humidity ");
  Serial.print (hobbyAirHum);
  Serial.print ("%  ");
  Serial.print (" - DHT22 Temperature ");
  Serial.print (hobbyAirTemp);
  Serial.println ("°C");   
  delay(10000);
}




void do_send(osjob_t* j) {
  if (LMIC.opmode & OP_TXRXPEND) {
    Serial.println("OP_TXRXPEND, not sending");
  }else{
    uint8_t batteryValue = 0;     // TODO batteryValue is not yet implemented; reserved for future use.
    hobbyAirTemp = dht.readTemperature();    //Read temperature as Celsius DHT22
    hobbyAirHum = dht.readHumidity();     //Reading takes 250 milliseconds DHT22
    Serial.print (" - DHT22 Humidity ");
    Serial.print (hobbyAirHum);
    Serial.println ("%");
    Serial.print (" - DHT22 Temperature ");
    Serial.print (hobbyAirTemp);
    Serial.println ("°C");      
    
    uint16_t medianSensorPM25 = 25;
    uint16_t medianSensorPM10 = 10;
    uint16_t medianSensorHumidity = hobbyAirHum;
    uint16_t medianSensorTemperature = hobbyAirTemp;

    byte payload[8];
    payload[0] = batteryValue;
    payload[1] = highByte(medianSensorPM25);
    payload[2] = lowByte(medianSensorPM25);
    payload[3] = highByte(medianSensorPM10);       // Encode SDS011 PM10 value
    payload[4] = lowByte(medianSensorPM10);
    payload[5] = lowByte((uint8_t)(medianSensorHumidity * 0.1));
    payload[6] = highByte(medianSensorTemperature);
    payload[7] = lowByte(medianSensorTemperature);
    LMIC_setTxData2(1, payload, sizeof(payload), 0);
    Serial.println("Packet queued");
  }
}





void onEvent (ev_t ev) {
  Serial.print(os_getTime() + ": ");
  switch(ev) {
    
    case EV_SCAN_TIMEOUT:
      Serial.println("EV_SCAN_TIMEOUT");
      break;
      
    case EV_BEACON_FOUND:
      Serial.println("EV_BEACON_FOUND");
      break;
      
    case EV_BEACON_MISSED:
      Serial.println("EV_BEACON_MISSED");
      break;
      
    case EV_BEACON_TRACKED:
      Serial.println("EV_BEACON_TRACKED");
      break;
      
    case EV_JOINING:
      Serial.println("EV_JOINING");
      break;
      
    case EV_JOINED:
      Serial.println("EV_JOINED");
            // Set spreading factor to maximise range (SF12)
            //LMIC_setDrTxpow(DR_SF12, 14);
            // Disable link check validation (automatically enabled
            // during join, but not supported by TTN at this time).
       LMIC_setLinkCheckMode(0);
       break;
       
    case EV_RFU1:
      Serial.println("EV_RFU1");
      break;
      
    case EV_JOIN_FAILED:
      Serial.println("EV_JOIN_FAILED");
      break;
      
    case EV_REJOIN_FAILED:
      Serial.println("EV_REJOIN_FAILED");
      break;
      
    case EV_TXCOMPLETE:
      Serial.println("EV_TXCOMPLETE (includes waiting for RX windows)");
            if (LMIC.txrxFlags & TXRX_ACK)
              Serial.println("Received ack");
            if (LMIC.dataLen) {
               Serial.println("Received ");
               Serial.println(LMIC.dataLen);
               Serial.println(" bytes of payload");
            }
            // Send the arduino to sleep until next transmission
            // for (int i=0; i<(int)(TX_INTERVAL/8); i++) {
            //     LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF);
            // }
         do_send(&sendjob);
         os_setTimedCallback(&sendjob, os_getTime()+sec2osticks(TX_INTERVAL), do_send);
       break;
       
    case EV_LOST_TSYNC:
      Serial.println("EV_LOST_TSYNC");
      break;
      
    case EV_RESET:
      Serial.println("EV_RESET");
      break;
      
    case EV_RXCOMPLETE:                       // data received in ping slot
      Serial.println("EV_RXCOMPLETE");
      break;
      
    case EV_LINK_DEAD:
      Serial.println("EV_LINK_DEAD");
      break;
      
    case EV_LINK_ALIVE:
      Serial.println("EV_LINK_ALIVE");
      break;
            
    default:
      Serial.println("Mijn Unknown event");
      break;
  }
}
