////////////////////////////////////////////////////////////////////////////////
// Naam:       DHT22-node02.ino                                               //
//             01 = Laat regelmatig DHT meting zien op de seriele monitor     //
//             02 = Eerste TTN resultaten                                     //
//                                                                            //
// LET OP: WERKT ENKEL INDIEN config.h WORDT MEEGEINSTALLEERD                 //
//                                                                            //
//             http://robotigs.com/robots/includes/bots.php?idbot=17          //
//             Speeltje om T-Beam te testen, Okk vingeroefening in beperkt    //
//             geheugengebruik.                                               //
// Created by: HARB rboek2@gmail.com October 2020 GPL copyrights              //
// Platform:   TTGO T-Beam V1.0                                               //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
//                                                                            //
// As inputs the following modules are mounted:                               //
// - DHT22 Temperatuur en luchtvochtigheids sensor                            //
//           http://robotigs.nl/robots/includes/parts.php?idpart=252          //
//                                                                            //
// For communications and statistics are mounted:                             //
// - Standard Serial Monitor output                                           //
//            http://robotigs.nl/robots/includes/parts.php?idpart=43          //
////////////////////////////////////////////////////////////////////////////////


// SET PRECOMPILER OPTIONS *****************************************************
  //Initialse conditional compiling, uncomment to include, comment to exclude --
  // Do comment for runtime versions
  //#define RS232                 //Uncomment to include Serial Monitor sections

  //Define the needed header files for the precompiler, no charge if not used --
  #include <Preferences.h>
  #include "rom/rtc.h"   //Bibliotheek om bij bepaalde registers te kunnen komen
  #include <SPI.h>
  #include <lmic.h>
  #include <hal/hal.h>
  #include <vector>
  #include "config.h"
  #include <DHT.h> //Needed for DHT22 and DHT11 Temperature and humidity sensors
             // http://robotigs.nl/robotigs/includes/parts_header.php?idpart=252

  //Define PINS ----------------------------------------------------------------
  #define DHT22_PIN 13                                //Sensor DHT22 pin mapping
  #define DHTTYPE   DHT11     //What sensor is connected (AM2302) (AM2321) DHT22
  DHT dht(DHT22_PIN, DHTTYPE);                         //Initialize DHT22 sensor

  const lmic_pinmap lmic_pins = {
    .nss = NSS_GPIO,
    .rxtx = LMIC_UNUSED_PIN,
    .rst = RESET_GPIO,
    .dio = {DIO0_GPIO, DIO1_GPIO, DIO2_GPIO},
  };

  //Define variables -----------------------------------------------------------
  #define TX_INTERVAL 100000
  float  hobbyAirTemp   = 0;              //Air temperature degree Celsius DHT22
  float  hobbyAirHum    = 0;                     //Air humidity percentage DHT22
  static osjob_t sendjob;
  bool   packetSent, packetQueued;
  static uint8_t txBuffer[10];
  unsigned long resetCounter   = 30000000;         //Reset value if zero SENSORS
  unsigned long readCounter    = 3000;            //Read sensors if counted down
  
  // Must be unique per application
  #define DEVEUI { 0x2F, 0x30, 0x0D, 0xBB, 0xF9, 0x3A, 0xDB, 0x00 }
  static u1_t devEUI[8] = DEVEUI; // Device EUI, LSB
  void os_getDevEui (u1_t* buf) {
	  memcpy(buf, devEUI, 8);
  }

  // Should end with 0xD5, 0xB3, 0x70 for TTN
  #define APPEUI { 0x4B, 0x3F, 0x03, 0xD0, 0x7E, 0xD5, 0xB3, 0x70 }
  static const u1_t PROGMEM appEUI[8] = APPEUI;    // Application EUI, LSB
  void os_getArtEui (u1_t* buf) {
	  memcpy_P(buf, appEUI, 8);
  }


  #define APPKEY { 0xC9, 0x42, 0x39, 0xBF, 0xE2, 0xA9, 0x91, 0x91, 0xF0, 0xE5, 0x28, 0x16, 0x11, 0x54, 0x3F, 0x98 }
  static const u1_t PROGMEM appKey[16] = APPKEY;   // App Key, MSB
  void os_getDevKey (u1_t* buf) {
	  memcpy_P(buf, appKey, 16);
  }


void setup() { //Setup runs once ***********************************************
  Serial.begin(115200);       //Nothing more needed for the Serial Monitor RS232
  Serial.println("SETUP start *****************************");
  Serial.println("");
  //Start objects --------------------------------------------------------------
  dht.begin();  
  if (!ttn_setup()) {                                                //TTN setup
    Serial.println("[ERR] Radio module not found!");
  }else{            //Else of if (!ttn_setup())
    ttn_register(callback);
    ttn_join();
    ttn_adr(LORAWAN_ADR);
  } //End of if (!ttn_setup())
  Serial.println("klaar \n");
} //End of setup ---------------------------------------------------------------





void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  os_runloop_once();
  if (packetSent) {
    packetSent = false;
  } //End of if (packetSent)
  readSensors();         //Read sensors at timed intervals only and publish data
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER







void readSensors() { //Read sensors at timed intervals only ********************
  if (readCounter == 0){       //Only perform measurements if counted down TIMER
    readCounter = resetCounter;                              //RESET the counter 
    hobbyAirTemp = dht.readTemperature();    //Read temperature as Celsius DHT22
    hobbyAirHum = dht.readHumidity();     //Reading takes 250 milliseconds DHT22
    //Serial.print (" - DHT22 Humidity ");
    //Serial.print (hobbyAirHum);
    //Serial.print ("%  ");
    //Serial.print (" - DHT22 Temperature ");
    //Serial.print (hobbyAirTemp);
    //Serial.println ("°C");   
    trySend();
  }else{                                //Meaning counter was not yet zero TIMER
    readCounter--;                        //Decrement of the timer counter TIMER
  } //End of if (moistureCnt1 == 0)Perform measurements if counted down    TIMER
} //Exit readSensors -----------------------------------------------------------












void buildPacket(uint8_t txBuffer[]);  //Needed for TTN *************************


bool trySend() {   // If we have a valid position send it to the server. @return true if we decided to send.
  packetSent = false;
  char buffer[40];
  snprintf(buffer, sizeof(buffer), " - DHT22_Temperatuur:%3.1f°C  ", hobbyAirTemp);
     Serial.print(buffer);
  snprintf(buffer, sizeof(buffer), "DHT22_Luchtvocht:%2.0f  ", hobbyAirHum);
     Serial.print(buffer);
  snprintf(buffer, sizeof(buffer), "Accu:48 - ");
     Serial.print(buffer);
  //buildPacket(txBuffer);
  /*
  Serial.print(txBuffer[1]);
    Serial.print(txBuffer[2]);
      Serial.print(txBuffer[3]);
        Serial.print(txBuffer[4]);
          Serial.print(txBuffer[5]);
            Serial.print(txBuffer[6]);
              Serial.print(txBuffer[7]);
    */          
  #if LORAWAN_CONFIRMED_EVERY > 0
    bool confirmed = (count % LORAWAN_CONFIRMED_EVERY == 0);
  #else
    bool confirmed = false;
  #endif
  ttn_send(txBuffer, sizeof(txBuffer), LORAWAN_PORT, confirmed);
  packetQueued = true;
} //End of  bool trySend()  ----------------------------------------------------







void callback(uint8_t message) {
  if (EV_JOINING == message)         Serial.print("Joining TTN...\n");
  if (EV_JOINED == message)          Serial.print("TTN joined!\n"); 
  if (EV_JOIN_FAILED == message)     Serial.print("TTN join failed\n");
  if (EV_REJOIN_FAILED == message)   Serial.print("TTN rejoin failed\n");
  if (EV_RESET == message)           Serial.print("Reset TTN connection\n");
  if (EV_LINK_DEAD == message)       Serial.print("TTN link dead\n");
  if (EV_ACK == message)             Serial.print("ACK received\n");
  if (EV_PENDING == message)         Serial.print("Message discarded\n");
  if (EV_QUEUED == message)          Serial.print("Message queued\n");

  if (EV_TXCOMPLETE == message && packetQueued) {   // We only want to say 'packetSent' for our packets (not packets needed for joining)
    Serial.print("Message sent\n");
    packetQueued = false;
    packetSent = true;
  }

  if (EV_RESPONSE == message) {
    Serial.print("[TTN] Response: ");
    size_t len = ttn_response_len();
    uint8_t data[len];
    ttn_response(data, len);
    char buffer[6];
    for (uint8_t i = 0; i < len; i++) {
      snprintf(buffer, sizeof(buffer), "%02X", data[i]);
      Serial.print(buffer);
    }
    Serial.print("\n");
  }
}





void do_send(osjob_t* j) {
  if (LMIC.opmode & OP_TXRXPEND) {
    Serial.println("OP_TXRXPEND, not sending");
  }else{
    uint8_t batteryValue = 0;     // TODO batteryValue is not yet implemented; reserved for future use.
    hobbyAirTemp = dht.readTemperature();    //Read temperature as Celsius DHT22
    hobbyAirHum = dht.readHumidity();     //Reading takes 250 milliseconds DHT22
    Serial.print (" - DHT22 Humidity ");
    Serial.print (hobbyAirHum);
    Serial.println ("%");
    Serial.print (" - DHT22 Temperature ");
    Serial.print (hobbyAirTemp);
    Serial.println ("°C");      
    
    uint16_t medianSensorPM25 = 25;
    uint16_t medianSensorPM10 = 10;
    uint16_t medianSensorHumidity = hobbyAirHum;
    uint16_t medianSensorTemperature = hobbyAirTemp;

    byte payload[8];
    payload[0] = batteryValue;
    payload[1] = highByte(medianSensorPM25);
    payload[2] = lowByte(medianSensorPM25);
    payload[3] = highByte(medianSensorPM10);       // Encode SDS011 PM10 value
    payload[4] = lowByte(medianSensorPM10);
    payload[5] = lowByte((uint8_t)(medianSensorHumidity * 0.1));
    payload[6] = highByte(medianSensorTemperature);
    payload[7] = lowByte(medianSensorTemperature);
    LMIC_setTxData2(1, payload, sizeof(payload), 0);
    Serial.println("Packet queued");
  }
}






void onEvent(ev_t event) { // LMIC library will call this method when an event is fired
  switch(event) {
    case EV_JOINED: {
        #ifdef SINGLE_CHANNEL_GATEWAY
        forceTxSingleChannelDr();
        #endif

        // Disable link check validation (automatically enabled
        // during join, but because slow data rates change max TX
        // size, we don't use it in this example.
        if(!LORAWAN_ADR){
            LMIC_setLinkCheckMode(0); // Link check problematic if not using ADR. Must be set after join
        }

        Serial.println(F("EV_JOINED"));

        u4_t netid = 0;
        devaddr_t devaddr = 0;
        u1_t nwkKey[16];
        u1_t artKey[16];
        LMIC_getSessionKeys(&netid, &devaddr, nwkKey, artKey);
        Serial.print("netid: ");
        Serial.println(netid, DEC);
        Serial.print("devaddr: ");
        Serial.println(devaddr, HEX);
        Serial.print("AppSKey: ");
        for (size_t i=0; i<sizeof(artKey); ++i) {
            if (i != 0)
                Serial.print("-");
            printHex2(artKey[i]);
        }
        Serial.println("");
        Serial.print("NwkSKey: ");
        for (size_t i=0; i<sizeof(nwkKey); ++i) {
            if (i != 0)
                    Serial.print("-");
            printHex2(nwkKey[i]);
        }
        Serial.println();

        Preferences p;
        if(p.begin("lora", false)) {
            p.putUInt("netId", netid);
            p.putUInt("devAddr", devaddr);
            p.putBytes("nwkKey", nwkKey, sizeof(nwkKey));
            p.putBytes("artKey", artKey, sizeof(artKey));
            p.end();
        }
        break; }
    case EV_TXCOMPLETE:
        Serial.println(F("EV_TXCOMPLETE (inc. RX win. wait)"));
        if (LMIC.txrxFlags & TXRX_ACK) {
            Serial.println(F("Received ack"));
            _ttn_callback(EV_ACK);
        }
        if (LMIC.dataLen) {
            Serial.print(F("Data Received: "));
            Serial.write(LMIC.frame+LMIC.dataBeg, LMIC.dataLen);
            Serial.println();
            _ttn_callback(EV_RESPONSE);
        }
        break;
    default:
        break;
    }

    // Send message callbacks
    _ttn_callback(event);
}


static void printHex2(unsigned v) {
    v &= 0xff;
    if (v < 16)
        Serial.print('0');
    Serial.print(v, HEX);
}

void _ttn_callback(uint8_t message) {
    //for (uint8_t i=0; i<_lmic_callbacks.size(); i++) {
    //    (_lmic_callbacks[i])(message);
    //}
}

/*


void onEvent (ev_t ev) {
  Serial.print(os_getTime() + ": ");
  switch(ev) {
    
    case EV_SCAN_TIMEOUT:
      Serial.println("EV_SCAN_TIMEOUT");
      break;
      
    case EV_BEACON_FOUND:
      Serial.println("EV_BEACON_FOUND");
      break;
      
    case EV_BEACON_MISSED:
      Serial.println("EV_BEACON_MISSED");
      break;
      
    case EV_BEACON_TRACKED:
      Serial.println("EV_BEACON_TRACKED");
      break;
      
    case EV_JOINING:
      Serial.println("EV_JOINING");
      break;
      
    case EV_JOINED:
      Serial.println("EV_JOINED");
            // Set spreading factor to maximise range (SF12)
            //LMIC_setDrTxpow(DR_SF12, 14);
            // Disable link check validation (automatically enabled
            // during join, but not supported by TTN at this time).
       LMIC_setLinkCheckMode(0);
       break;
       
    case EV_RFU1:
      Serial.println("EV_RFU1");
      break;
      
    case EV_JOIN_FAILED:
      Serial.println("EV_JOIN_FAILED");
      break;
      
    case EV_REJOIN_FAILED:
      Serial.println("EV_REJOIN_FAILED");
      break;
      
    case EV_TXCOMPLETE:
      Serial.println("EV_TXCOMPLETE (includes waiting for RX windows)");
            if (LMIC.txrxFlags & TXRX_ACK)
              Serial.println("Received ack");
            if (LMIC.dataLen) {
               Serial.println("Received ");
               Serial.println(LMIC.dataLen);
               Serial.println(" bytes of payload");
            }
            // Send the arduino to sleep until next transmission
            // for (int i=0; i<(int)(TX_INTERVAL/8); i++) {
            //     LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF);
            // }
         do_send(&sendjob);
         os_setTimedCallback(&sendjob, os_getTime()+sec2osticks(TX_INTERVAL), do_send);
       break;
       
    case EV_LOST_TSYNC:
      Serial.println("EV_LOST_TSYNC");
      break;
      
    case EV_RESET:
      Serial.println("EV_RESET");
      break;
      
    case EV_RXCOMPLETE:                       // data received in ping slot
      Serial.println("EV_RXCOMPLETE");
      break;
      
    case EV_LINK_DEAD:
      Serial.println("EV_LINK_DEAD");
      break;
      
    case EV_LINK_ALIVE:
      Serial.println("EV_LINK_ALIVE");
      break;
            
    default:
      Serial.println("Mijn Unknown event");
      break;
  }
}

*/


void ttn_join() {
  LMIC_reset();           //Reset the MAC state. Session and pending data transfers will be discarded
            // Set up the channels used by the Things Network, which corresponds
            // to the defaults of most gateways. Without this, only three base
            // channels from the LoRaWAN specification are used, which certainly
            // works, so it is good for debugging, but can overload those
            // frequencies, so be sure to configure the full frequency range of
            // your network here (unless your network autoconfigures them).
            // Setting up channels should happen after LMIC_setSession, as that
            // configures the minimal channel set.
  LMIC_setupChannel(0, 868100000, DR_RANGE_MAP(DR_SF12, DR_SF7),  BAND_CENTI);      // g-band
  LMIC_setupChannel(1, 868300000, DR_RANGE_MAP(DR_SF12, DR_SF7B), BAND_CENTI);      // g-band
  LMIC_setupChannel(2, 868500000, DR_RANGE_MAP(DR_SF12, DR_SF7),  BAND_CENTI);      // g-band
  LMIC_setupChannel(3, 867100000, DR_RANGE_MAP(DR_SF12, DR_SF7),  BAND_CENTI);      // g-band
            LMIC_setupChannel(4, 867300000, DR_RANGE_MAP(DR_SF12, DR_SF7),  BAND_CENTI);      // g-band
            LMIC_setupChannel(5, 867500000, DR_RANGE_MAP(DR_SF12, DR_SF7),  BAND_CENTI);      // g-band
            LMIC_setupChannel(6, 867700000, DR_RANGE_MAP(DR_SF12, DR_SF7),  BAND_CENTI);      // g-band
            LMIC_setupChannel(7, 867900000, DR_RANGE_MAP(DR_SF12, DR_SF7),  BAND_CENTI);      // g-band
            LMIC_setupChannel(8, 868800000, DR_RANGE_MAP(DR_FSK,  DR_FSK),  BAND_MILLI);      // g2-band

        LMIC_setLinkCheckMode(0);         // Disable link check validation
        #ifdef SINGLE_CHANNEL_GATEWAY
          forceTxSingleChannelDr();
        #else
          ttn_sf(LORAWAN_SF); //Set default rate and transmit power for uplink (note: txpow seems to be ignored by the library)
        #endif

        LMIC_startJoining();  // Make LMiC initialize the default channels, choose a channel, and schedule the OTAA join

        #ifdef SINGLE_CHANNEL_GATEWAY
          LMIC.txChnl = SINGLE_CHANNEL_GATEWAY; //LMiC will already have decided to send on one of the 3 default channels; ensure it uses the one we want
        #endif

        Preferences p;
        p.begin("lora", true); // we intentionally ignore failure here
        uint32_t netId = p.getUInt("netId", UINT32_MAX);
        uint32_t devAddr = p.getUInt("devAddr", UINT32_MAX);
        uint8_t nwkKey[16], artKey[16];
        bool keysgood = p.getBytes("nwkKey", nwkKey, sizeof(nwkKey)) == sizeof(nwkKey) && 
                        p.getBytes("artKey", artKey, sizeof(artKey)) == sizeof(artKey);
        p.end(); // close our prefs

        if(!keysgood) {
            // We have not yet joined a network, start a full join attempt
            // Make LMiC initialize the default channels, choose a channel, and
            // schedule the OTAA join
            Serial.println("No session saved, joining from scratch");
            LMIC_startJoining();
        }
        else {
            Serial.println("Rejoining saved session");
            LMIC_setSession(netId, devAddr, nwkKey, artKey);

            // Trigger a false joined
            _ttn_callback(EV_JOINED);
        }
}




/*==========================================================================
 * Tutorial Link: https://arduinobasics.blogspot.com/2019/05/sprintf-function.html
 * %d = signed integer               %f = floating point number  
 * %s = string                     %.1f = float to 1 decimal place
 * %c = character                  %.3f = float to 3 decimal places
 * %e = scientific notation          %g = shortest representation of %e or %f                
 * %u = unsigned integer             %o = unsigned octal
 * %x = unsigned hex (lowercase)     %X = unsigned hex (uppercase)
 * %hd = short int                  %ld = long int
 * %lld = long long int
 * =============================================================================  */
