#pragma once


// uncomment to use OTAA instead of ABP
#define USE_OTAA 1


// UPDATE WITH YOUR DEVICE TTN SECRETS
#ifdef USE_OTAA
static PROGMEM u1_t DEVEUI[8]  = { 0x2F, 0x30, 0x0D, 0xBB, 0xF9, 0x3A, 0xDB, 0x00 }; // Device EUI, hex, lsb
static PROGMEM u1_t APPEUI[8]  = { 0x4B, 0x3F, 0x03, 0xD0, 0x7E, 0xD5, 0xB3, 0x70 }; // Application EUI, hex, lsb
static PROGMEM u1_t APPKEY[16] = { 0xC9, 0x42, 0x39, 0xBF, 0xE2, 0xA9, 0x91, 0x91, 0xF0, 0xE5, 0x28, 0x16, 0x11, 0x54, 0x3F, 0x98 }; // App Key, hex, msb
#else
static PROGMEM u1_t NWKSKEY[16] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }; // LoRaWAN NwkSKey, network session key, hex, msb
static PROGMEM u1_t APPSKEY[16] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }; // LoRaWAN AppSKey, application session key, hex, msb
static PROGMEM u4_t DEVADDR = 0x00000000 ; // LoRaWAN end-device address (DevAddr), hex, msb
#endif
