////////////////////////////////////////////////////////////////////////////////
// Name:       GPSklok_4in1_once.ino                                          //
//             01 = Ziet er leuk uit en loopt strak op tijd. Gebruikt GPS om  //
//                  aan de juiste tijd te komen. En leest ook nog een BLE     //
//                  4in1 sensor uit.                                          //
// http://robotigs.nl/robots/includes/parts.php?idpart=113                    //
// Created by: HARB rboek2@gmail.com September 2020 GPL copyrights            //
// Original:   https://github.com/ThingPulse/esp8266-oled-ssd1306             //
// Platform:   TTGO T-Beam V1.0                                               //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
//                                                                            //
// As inputs the following modules are mounted:                               //
//                                                                            //
// For communications and statistics are mounted:                             //
////////////////////////////////////////////////////////////////////////////////

  //Define the needed header files for the precompiler, no charge if not used --
  #include "configuration.h"            //Contains the pinmap of the T-Beam v1.0
  //#include "credentials.h"                             //Credential Login data
  #include <TimeLib.h>                 // https://github.com/PaulStoffregen/Time
  #include <Wire.h>                                      // Only needed for oled
  #include "SSD1306Wire.h" // https://github.com/ThingPulse/esp8266-oled-ssd1306
  #include "OLEDDisplayUi.h"                               // Include the UI lib
  #include "images.h"                                   // Include custom images
  #include "axp20x.h"             // https://github.com/lewisxhe/AXP202X_Library
  #include <TinyGPS++.h>    // https://github.com/mikalhart/TinyGPSPlus/releases
  #include "BLEDevice.h"      //BLE code is now included in Arduino IDE directly

  RTC_DATA_ATTR int bootCount = 0; // boot count used to check if battery status should be read
  static int deviceCount = sizeof FLORA_DEVICES / sizeof FLORA_DEVICES[0]; // device count
  static BLEUUID serviceUUID("00001204-0000-1000-8000-00805f9b34fb"); // the remote service we wish to connect to
  static BLEUUID uuid_version_battery("00001a02-0000-1000-8000-00805f9b34fb"); // the characteristic of the remote 
  static BLEUUID uuid_sensor_data("00001a01-0000-1000-8000-00805f9b34fb");     //service we are interested in
  static BLEUUID uuid_write_mode("00001a00-0000-1000-8000-00805f9b34fb");

  //Define PINS ----------------------------------------------------------------
  //Define EEPROM variables ----------------------------------------------------
  //Define DATABASE VARIABLES --------------------------------------------------
  //Define variables -----------------------------------------------------------
  char         precisie[6]     = "999";                        //Nodig voor oled
  char         snelheid[10]    = "999";                        //Nodig voor oled
  char         sats[4]         = "999"; //gps.satellites.value() Nodig voor oled
  char         temp[6]         = "99999";                      //Nodig voor oled
  char         mois[4]         = "999";                        //Nodig voor oled
  char         ligh[6]         = "99999";                      //Nodig voor oled
  char         cnts[8]         = "99999";                      //Nodig voor oled
  char         salt[4]         = "999"; //gps.satellites.value() Nodig voor oled
  char         volt[12]         = "999";                      // Nodig voor oled
  char         cons[12]         = "999";                      // Nodig voor oled
  char         laad[12]         = "999";                      // Nodig voor oled
  char         tmp1[12]         = "999";                      // Nodig voor oled
  int          battery;                               //Waarde van 4in1 batterij
  char         bat1[12]         = "999";                      // Nodig voor oled 
  float        temperature = 0;
  int          moisture = 0;
  int          light = 0;
  int          conductivity = 0;
  bool pmu_irq = false;
  String baChStatus = "No charging";
  bool ssd1306_found = false;
  bool axp192_found = false;
  bool packetSent, packetQueued;
  long timezone = 1; 
  byte daysavetime = 1;
  int screenW = 128;
  int screenH = 64;
  int clockCenterX = screenW/2;
  int clockCenterY = ((screenH-16)/2+9);     // top yellow part is 16 px height
  int clockRadius = 31;
  char buffer[20];
  //RTC_DATA_ATTR int bootCount = 0;    // deep sleep support
  unsigned long resetCounter   = 300000;            //Reset value if zero SENSORS
  unsigned long readCounter    = resetCounter;     //Read sensors if counted down
  bool readBattery = ((bootCount % BATTERY_INTERVAL) == 0); //check if battery status should be read-based on boot count
  String twoDigits(int digits){  // utility function for digital clock display: prints leading 0
    if(digits < 10){
      String i = '0'+String(digits);
      return i;
    }else{
      return String(digits);
    }//End of if(digits < 10)
  } //End of String twoDigits

  //Initialize OBJECTS ---------------------------------------------------------
  TinyGPSPlus gps;
  HardwareSerial GPS(1);
  AXP20X_Class axp;
  SSD1306Wire  display(0x3c, 21, 22);             //T-Beam V1.0 => SDA=21 SCL=22
  OLEDDisplayUi ui ( &display );
  FrameCallback frames[] = {digitalClockFrame, analogClockFrame, GPSframe, bleframe, accuframe}; //Keeps pointers to all frames
  int frameCount = 5;   // how many frames are there?  // frames are the single views that slide in
  OverlayCallback overlays[] = { clockOverlay }; //Overlays are statically drawn on top of a frame eg. a clock
  int overlaysCount = 1;






void setup(){ //Setup runs once ************************************************
  Serial.begin(115200);
  Serial.println("Setup");

  //Start objects --------------------------------------------------------------
  Wire.begin(I2C_SDA, I2C_SCL); //Oled & PowerIC
  scanI2Cdevice();
  axp192Init();                                               //Loopt ook op I2C
  
  ui.setTargetFPS(60);                                     //Ok voor T-Beam V1.0
  ui.setActiveSymbol(activeSymbol);   //Customize the active and inactive symbol
  ui.setInactiveSymbol(inactiveSymbol);
  ui.setIndicatorPosition(RIGHT);                    //TOP, LEFT, BOTTOM, RIGHT
  ui.setIndicatorDirection(LEFT_RIGHT);//Where first frame is located in the bar
  ui.setFrameAnimation(SLIDE_DOWN);//SLIDE_LEFT SLIDE_RIGHT SLIDE_UP SLIDE_DOWN
  ui.setFrames(frames, frameCount);                                 //Add frames
  ui.setOverlays(overlays, overlaysCount);                        //Add overlays
  ui.setTimePerFrame(10000);                                        //Tijd in ms
  ui.init();                     //Initialising the UI will init the display too
  display.flipScreenVertically();

  //display.setFont(ArialMT_Plain_24); //24, 16 en 10
  //display.drawString(20 , 20, "- Setup running");
  //ui.disableIndicator(); ik zie geen verandering
  ui.update();                                               //Show we are activ






  GPS.begin(9600, SERIAL_8N1, 34, 12);                             //T-Beam V1.0
  while (gps.satellites.value() < 3){  //Controleer dat de GPS ontvangst goed is
    while (GPS.available()) {
      gps.encode(GPS.read());
    }
  }
  int uur     = gps.time.hour()+2;
  int minuut  = gps.time.minute();
  int seconde = gps.time.second();
  int dag     = gps.date.day();
  int maand   = gps.date.month();
  int jaar    = gps.date.year();
  setTime( uur, minuut, seconde, dag, maand, jaar);

  
  //Test hardware and software -------------------------------------------------
  Serial.print("Latitude  : ");
  Serial.println(gps.location.lat(), 5);
  Serial.print("Longitude : ");
  Serial.println(gps.location.lng(), 4);
  Serial.print("Satellites: ");
  Serial.println(gps.satellites.value());
  Serial.print("Altitude  : ");
  Serial.print(gps.altitude.feet() / 3.2808);
  Serial.println("M");
  Serial.print("Speed     : ");
  Serial.println(gps.speed.kmph()); 
  Serial.println("**********************");

  
  Serial.println("Initialize BLE client...");
  BLEDevice::init("4in1");
  BLEDevice::setPower(ESP_PWR_LVL_P7);
  for (int i=0; i<deviceCount; i++) {  // process devices
    int tryCount = 0;
    char* deviceMacAddress = FLORA_DEVICES[i];
    BLEAddress floraAddress(deviceMacAddress);
    while (tryCount < RETRY) {
      tryCount++;
      if (processFloraDevice(floraAddress, deviceMacAddress, readBattery, tryCount)) {
        break;
      } //End of if 
      delay(1000);
    } //End of while
    delay(1500);
  } //End of for
} //End of setup ---------------------------------------------------------------









void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  readSensors();         //Read sensors at timed intervals only and publish data
  while (GPS.available()) { gps.encode(GPS.read()); }      //Haal als GPS spuugt
  int remainingTimeBudget = ui.update();
  if (remainingTimeBudget > 0) {                     //You can do some work here
    delay(remainingTimeBudget);   //Dont do it if you are below your time budget
  } //End of if (remainingTimeBudget > 0)
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER



/*==========================================================================
 * Tutorial Link: https://arduinobasics.blogspot.com/2019/05/sprintf-function.html
 * %d = signed integer               %f = floating point number  
 * %s = string                     %.1f = float to 1 decimal place
 * %c = character                  %.3f = float to 3 decimal places
 * %e = scientific notation          %g = shortest representation of %e or %f                
 * %u = unsigned integer             %o = unsigned octal
 * %x = unsigned hex (lowercase)     %X = unsigned hex (uppercase)
 * %hd = short int                  %ld = long int
 * %lld = long long int
 * =============================================================================  */
void GPSframe(OLEDDisplay *display, OLEDDisplayUiState* state, int16_t x, int16_t y) {
  display->setTextAlignment(TEXT_ALIGN_LEFT);
  sprintf(snelheid, "%.1f", gps.speed.kmph());      //Prepare for Oled
  sprintf(precisie, "%u", gps.hdop.value());             //Prepare for Oled
  sprintf(sats, "%u", gps.satellites.value());           //Prepare for Oled
  sprintf(cnts, "%u", readCounter);                    //Prepare for Oled
  display->setFont(ArialMT_Plain_16); //24, 16 en 10
  display->drawString(0 , 0+y, "GPS");
  display->setFont(ArialMT_Plain_10); //24, 16 en 10
  display->drawString(0 , 20+y, "Hdop");
  display->drawString(70 , 20+y, precisie );
  display->drawString(0 , 30+y, "Snelheid");
  display->drawString(70 , 30+y, snelheid );
  display->drawString(0 , 40+y, "Satelliet");
  display->drawString(70 , 40+y, sats );
  display->drawString(0 , 50+y, "Teller4in1");
  display->drawString(70 , 50+y, cnts );
}




void bleframe(OLEDDisplay *display, OLEDDisplayUiState* state, int16_t x, int16_t y) {
  display->setTextAlignment(TEXT_ALIGN_LEFT);
  sprintf(temp, "%.1f", temperature);                         //Prepare for Oled
  sprintf(ligh, "%u",   light);                               //Prepare for Oled
  sprintf(salt, "%u",   conductivity);                        //Prepare for Oled
  sprintf(mois, "%u",   moisture);                            //Prepare for Oled
  sprintf(bat1, "%u%s",  battery, "%" );                      //Prepare for Oled
    
  display->setFont(ArialMT_Plain_16); //24, 16 en 10
  display->drawString(0 , 0+y, "4in1");
  
  display->drawString(70 , 0+y, bat1);
  display->setFont(ArialMT_Plain_10); //24, 16 en 10
  display->drawString(1 , 20+y, "Temperatuur");
  display->drawString(70 , 20+y, temp );
  display->drawString(1 , 30+y, "Licht");
  display->drawString(70 , 30+y, ligh );
  display->drawString(1 , 40+y, "Geleiding");
  display->drawString(70 , 40+y, salt );
  display->drawString(1 , 50+y, "Vochtigheid");
  display->drawString(70 , 50+y, mois );
}





void accuframe(OLEDDisplay *display, OLEDDisplayUiState* state, int16_t x, int16_t y) {
  display->setTextAlignment(TEXT_ALIGN_LEFT);
  //snprintf(buffer, sizeof(buffer), "%.1fV %.0fmA", axp.getBattVoltage()/1000, axp.getBattChargeCurrent() - axp.getBattDischargeCurrent());
  sprintf(volt, "%.1f Vdc", axp.getBattVoltage()/1000);          //Prepair for Oled
  sprintf(cons, "%.0f mA", axp.getBattDischargeCurrent());      //Prepair for Oled
  sprintf(laad, "%.0f mA", axp.getBattChargeCurrent());         //Prepair for Oled
  sprintf(tmp1, "%.0f C", axp.getTemp());                      //Prepair for Oled
    
  display->setFont(ArialMT_Plain_16); //24, 16 en 10
  display->drawString(0 , 0+y, "Accu");
  display->setFont(ArialMT_Plain_10); //24, 16 en 10
  display->drawString(1 , 20+y, "Vdc");
  display->drawString(70 , 20+y, volt );
  display->drawString(1 , 30+y, "Verbruik");
  display->drawString(70 , 30+y, cons );
  display->drawString(1 , 40+y, "Laadstroom");
  display->drawString(70 , 40+y, laad );
  display->drawString(1 , 50+y, "Temperatuur");
  display->drawString(70 , 50+y, tmp1 );
}


void readSensors() { //Read sensors at timed intervals only ********************
  if (readCounter == 0){       //Only perform measurements if counted down TIMER
    readCounter = resetCounter;                        //RESET the counter TIMER
    /*
    Serial.println("");
    Serial.println("--> ReadSensors ");
    Serial.println("Initialize BLE client...");
    //BLEDevice::init("4in1");
    //BLEDevice::setPower(ESP_PWR_LVL_P7);
    for (int i=0; i<deviceCount; i++) {  // process devices
      int tryCount = 0;
      char* deviceMacAddress = FLORA_DEVICES[i];
      BLEAddress floraAddress(deviceMacAddress);
      while (tryCount < RETRY) {
        tryCount++;
        if (processFloraDevice(floraAddress, deviceMacAddress, readBattery, tryCount)) {
          break;
        }//End of if (processFloraDevice(f
        delay(1000);
      } //End of while (tryCount < RETRY)
      delay(1500);
    } //End of for (int i=0; i<deviceCount; i++)
    */
  }else{                                //Meaning counter was not yet zero TIMER
    readCounter--;                        //Decrement of the timer counter TIMER
  } //End of if (moistureCnt1 == 0)Perform measurements if counted down    TIMER
} //Exit readSensors -----------------------------------------------------------




static void smartDelay(unsigned long ms){
  unsigned long start = millis();
  do  {
    while (GPS.available()) {
      gps.encode(GPS.read());
    }
  } while (millis() - start < ms);
}






void scanI2Cdevice(void){
    byte err, addr;
    int nDevices = 0;
    for (addr = 1; addr < 127; addr++) {
        Wire.beginTransmission(addr);
        err = Wire.endTransmission();
        if (err == 0) {
            Serial.print("I2C device found at address 0x");
            if (addr < 16)
                Serial.print("0");
            Serial.print(addr, HEX);
            Serial.println(" !");
            nDevices++;

            if (addr == SSD1306_ADDRESS) {
                ssd1306_found = true;
                Serial.println("ssd1306 display found");
            }
            if (addr == AXP192_SLAVE_ADDRESS) {
                axp192_found = true;
                Serial.println("axp192 PMU found");
            }
        } else if (err == 4) {
            Serial.print("Unknow error at address 0x");
            if (addr < 16)
                Serial.print("0");
            Serial.println(addr, HEX);
        }
    }
    if (nDevices == 0)
        Serial.println("No I2C devices found\n");
    else
        Serial.println("done\n");
}






/**
 * Init the power manager chip
 * 
 * axp192 power 
    DCDC1 0.7-3.5V @ 1200mA max -> OLED // If you turn this off you'll lose comms to the axp192 because the
    // OLED and the axp192 share the same i2c bus, instead use ssd1306 sleep mode
    DCDC2 -> unused
    DCDC3 0.7-3.5V @ 700mA max -> ESP32 (keep this on!)
    LDO1 30mA -> charges GPS backup battery // charges the tiny J13 battery by the GPS 
    //to power the GPS ram (for a couple of days), can not be turned off
    LDO2 200mA -> LORA
    LDO3 200mA -> GPS
 */

void axp192Init() {   //https://github.com/kizniche/ttgo-tbeam-ttn-tracker
    if (axp192_found) {
        if (!axp.begin(Wire, AXP192_SLAVE_ADDRESS)) {
            Serial.println("AXP192 Begin PASS");
        } else {
            Serial.println("AXP192 Begin FAIL");
        }
        // axp.setChgLEDMode(LED_BLINK_4HZ);
        Serial.printf("DCDC1: %s\n", axp.isDCDC1Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("DCDC2: %s\n", axp.isDCDC2Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("LDO2: %s\n", axp.isLDO2Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("LDO3: %s\n", axp.isLDO3Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("DCDC3: %s\n", axp.isDCDC3Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("Exten: %s\n", axp.isExtenEnable() ? "ENABLE" : "DISABLE");
        Serial.println("----------------------------------------");

        axp.setPowerOutPut(AXP192_LDO2, AXP202_ON); // LORA radio
        axp.setPowerOutPut(AXP192_LDO3, AXP202_ON); // GPS main power
        axp.setPowerOutPut(AXP192_DCDC2, AXP202_ON);
        axp.setPowerOutPut(AXP192_EXTEN, AXP202_ON);
        axp.setPowerOutPut(AXP192_DCDC1, AXP202_ON);
        axp.setDCDC1Voltage(3300); // for the OLED power

        Serial.printf("DCDC1: %s\n", axp.isDCDC1Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("DCDC2: %s\n", axp.isDCDC2Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("LDO2: %s\n", axp.isLDO2Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("LDO3: %s\n", axp.isLDO3Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("DCDC3: %s\n", axp.isDCDC3Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("Exten: %s\n", axp.isExtenEnable() ? "ENABLE" : "DISABLE");

        //axp.setChgLEDMode(AXP20X_LED_OFF); // LED off
        //axp.setChgLEDMode(AXP20X_LED_BLINK_1HZ); // 1blink/sec, low rate
        //axp.setChgLEDMode(AXP20X_LED_BLINK_4HZ); // 4blink/sec, high rate
        //axp.setChgLEDMode(AXP20X_LED_LOW_LEVEL); // LED full on

        pinMode(PMU_IRQ, INPUT_PULLUP);
        attachInterrupt(PMU_IRQ, [] {
            pmu_irq = true;
        }, FALLING);

        axp.adc1Enable(AXP202_BATT_CUR_ADC1, 1);
  axp.enableIRQ(AXP202_VBUS_REMOVED_IRQ | AXP202_VBUS_CONNECT_IRQ | AXP202_BATT_REMOVED_IRQ | AXP202_BATT_CONNECT_IRQ, 1);
        axp.clearIRQ();

        if (axp.isChargeing()) {
            baChStatus = "Charging";
        }
    } else {
        Serial.println("AXP192 not found");
    }
}




BLERemoteService* getFloraService(BLEClient* floraClient) {
  BLERemoteService* floraService = nullptr;
  try { floraService = floraClient->getService(serviceUUID);  }
  catch (...) {  }     // something went wrong
  if (floraService == nullptr) {
    Serial.println("- Failed to find data service");
  } else {
    Serial.println("- Found data service");
  }
  return floraService;
}  //Exit BLERemoteService -------------------------------------------------------------



BLEClient* getFloraClient(BLEAddress floraAddress) { //*************************
  BLEClient* floraClient = BLEDevice::createClient();
  if (!floraClient->connect(floraAddress)) {
    Serial.println("- Connection failed, skipping");
    return nullptr;
  }
  Serial.println("- Connection successful");
  return floraClient;
} //Exit BLEClient -------------------------------------------------------------






bool forceFloraServiceDataMode(BLERemoteService* floraService) {
  BLERemoteCharacteristic* floraCharacteristic;
  Serial.println("- Force device in data mode");   // get device mode characteristic, needs to be changed to read data
  floraCharacteristic = nullptr;
  try { floraCharacteristic = floraService->getCharacteristic(uuid_write_mode); }
  catch (...) {  }     // something went wrong
  if (floraCharacteristic == nullptr) {
    Serial.println("-- Failed, skipping device");
    return false;
  }
  uint8_t buf[2] = {0xA0, 0x1F};   // write the magic data
  floraCharacteristic->writeValue(buf, 2, true);
  delay(500);
  return true;
}



bool readFloraDataCharacteristic(BLERemoteService* floraService, String baseTopic) {
  BLERemoteCharacteristic* floraCharacteristic = nullptr;

  Serial.println("- Access characteristic from device");   // get the main device data characteristic
  try { floraCharacteristic = floraService->getCharacteristic(uuid_sensor_data);  }
  catch (...) { }     // something went wrong
  if (floraCharacteristic == nullptr) {
    Serial.println("-- Failed, skipping device");
    return false;
  }

  Serial.println("- Read value from characteristic");   // read characteristic value
  std::string value;
  try {value = floraCharacteristic->readValue();}
  catch (...) {          // something went wrong
    Serial.println("-- Failed, skipping device"); 
    return false;
  }
  const char *val = value.c_str();
  Serial.print("Hex: ");
  for (int i = 0; i < 16; i++) {
    Serial.print((int)val[i], HEX);
    Serial.print(" ");
  }
  Serial.println(" ");

  int16_t* temp_raw = (int16_t*)val;
  temperature = (*temp_raw) / ((float)10.0);
  Serial.print(" Temperatuur: ");
  Serial.println(temperature);

  moisture = val[7];
  Serial.print("-- Moisture: ");
  Serial.println(moisture);

  light = val[3] + val[4] * 256;
  Serial.print("-- Light: ");
  Serial.println(light);
 
  conductivity = val[8] + val[9] * 256;
  Serial.print("-- Conductivity: ");
  Serial.println(conductivity);

  if (temperature > 200) {
    Serial.println("-- Unreasonable values received, skip publish");
    return false;
  }
  return true;
}




bool readFloraBatteryCharacteristic(BLERemoteService* floraService, String baseTopic) {
  BLERemoteCharacteristic* floraCharacteristic = nullptr;

  Serial.println("- Access battery characteristic from device");   // get the device battery characteristic
  try {
    floraCharacteristic = floraService->getCharacteristic(uuid_version_battery);
  }
  catch (...) {
    // something went wrong
  }
  if (floraCharacteristic == nullptr) {
    Serial.println("-- Failed, skipping battery level");
    return false;
  }

  // read characteristic value
  Serial.println("- Read value from characteristic");
  std::string value;
  try{
    value = floraCharacteristic->readValue();
  }
  catch (...) {
    // something went wrong
    Serial.println("-- Failed, skipping battery level");
    return false;
  }
  const char *val2 = value.c_str();
  battery = val2[0];
  char buffer[64];
  Serial.print("-- Battery: ");
  Serial.println(battery);
  return true;
}


void clockOverlay(OLEDDisplay *display, OLEDDisplayUiState* state) { }


void digitalClockFrame(OLEDDisplay *display, OLEDDisplayUiState* state, int16_t x, int16_t y) {
  String timenow = String(hour())+":"+twoDigits(minute())+":"+twoDigits(second());
  display->setTextAlignment(TEXT_ALIGN_CENTER);
  display->setFont(ArialMT_Plain_24);
  display->drawString(clockCenterX + x , 24 + y, timenow );
}



void analogClockFrame(OLEDDisplay *display, OLEDDisplayUiState* state, int16_t x, int16_t y) {
  display->drawCircle(clockCenterX + x, clockCenterY + y, 2);   // Draw the clock face
  for( int z=0; z < 360;z= z + 30 ){    //hour ticks
    float angle = z ;                   //Begin at 0° and stop at 360°
    angle = ( angle / 57.29577951 ) ;   //Convert degrees to radians
    int x2 = ( clockCenterX + ( sin(angle) * clockRadius ) );
    int y2 = ( clockCenterY - ( cos(angle) * clockRadius ) );
    int x3 = ( clockCenterX + ( sin(angle) * ( clockRadius - ( clockRadius / 8 ) ) ) );
    int y3 = ( clockCenterY - ( cos(angle) * ( clockRadius - ( clockRadius / 8 ) ) ) );
    display->drawLine( x2 + x , y2 + y , x3 + x , y3 + y);
  }

  float angle = second() * 6 ;   // display second hand
  angle = ( angle / 57.29577951 ) ; //Convert degrees to radians
  int x3 = ( clockCenterX + ( sin(angle) * ( clockRadius - ( clockRadius / 5 ) ) ) );
  int y3 = ( clockCenterY - ( cos(angle) * ( clockRadius - ( clockRadius / 5 ) ) ) );
  display->drawLine( clockCenterX + x , clockCenterY + y , x3 + x , y3 + y);

  angle = minute() * 6 ;            // display minute hand
  angle = ( angle / 57.29577951 ) ; //Convert degrees to radians
  x3 = ( clockCenterX + ( sin(angle) * ( clockRadius - ( clockRadius / 4 ) ) ) );
  y3 = ( clockCenterY - ( cos(angle) * ( clockRadius - ( clockRadius / 4 ) ) ) );
  display->drawLine( clockCenterX + x , clockCenterY + y , x3 + x , y3 + y);

  angle = hour() * 30 + int( ( minute() / 12 ) * 6 )   ;   // display hour hand
  angle = ( angle / 57.29577951 ) ; //Convert degrees to radians
  x3 = ( clockCenterX + ( sin(angle) * ( clockRadius - ( clockRadius / 2 ) ) ) );
  y3 = ( clockCenterY - ( cos(angle) * ( clockRadius - ( clockRadius / 2 ) ) ) );
  display->drawLine( clockCenterX + x , clockCenterY + y , x3 + x , y3 + y);
}




bool processFloraService(BLERemoteService* floraService, char* deviceMacAddress, bool readBattery) {
  if (!forceFloraServiceDataMode(floraService)) {   // set device in data mode
    return false;
  }
  String baseTopic = BASE_TOPIC + "/" + deviceMacAddress + "/";
  bool dataSuccess = readFloraDataCharacteristic(floraService, baseTopic);
  bool batterySuccess = true;
  if (readBattery) {
    batterySuccess = readFloraBatteryCharacteristic(floraService, baseTopic);
  }
  return dataSuccess && batterySuccess;
}



bool processFloraDevice(BLEAddress floraAddress, char* deviceMacAddress, bool getBattery, int tryCount) {
  Serial.print("Processing Flora device at ");
  Serial.print(floraAddress.toString().c_str());
  Serial.print(" (try ");
  Serial.print(tryCount);
  Serial.println(")");
  // connect to flora ble server
  BLEClient* floraClient = getFloraClient(floraAddress);
  if (floraClient == nullptr) {
    return false;
  }
  // connect data service
  BLERemoteService* floraService = getFloraService(floraClient);
  if (floraService == nullptr) {
    floraClient->disconnect();
    return false;
  }
  // process devices data
  bool success = processFloraService(floraService, deviceMacAddress, getBattery);
  // disconnect from device
  floraClient->disconnect();
  return success;
}
