////////////////////////////////////////////////////////////////////////////////
// Name:       bt_keyboard_leeslui_01.ino                                     //
//             01 = Ziet er leuk uit en loopt strak op tijd. Gebruikt WiFi    //
//                  om verbinding te maken met een tijdserver. Blauwe LED     //
//                  brandt nadat de ESP 32 is gestart. Als de witte knop      //
//                  wordt ingedrukt dan gaat het blauwe lampje uit.           //
// http://robotigs.nl/robots/includes/parts.php?idpart=387                    //
// Created by: HARB rboek2@gmail.com August 2021 GPL copyrights               //
// Original:   https://github.com/ThingPulse/esp8266-oled-ssd1306             //
// Platform:   TTGO T-Beam V1.0                                               //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
//                                                                            //
// As inputs the following modules are mounted:                               //
//                                                                            //
// For communications and statistics are mounted:                             //
////////////////////////////////////////////////////////////////////////////////


// SET PRECOMPILER OPTIONS *****************************************************
  //Define the needed header files for the precompiler, no charge if not used --
  #include <Wire.h>                         //Nodig voor Oled en Powermanagement
  #include "SSD1306Wire.h" // https://github.com/ThingPulse/esp8266-oled-ssd1306
  #include "OLEDDisplayUi.h"                               // Include the UI lib
  #include "axp20x.h"             // https://github.com/lewisxhe/AXP202X_Library

  //Define PINS ----------------------------------------------------------------
  #define PushButtonPin         2   //Pen waarop druk schakelaar is  aangesloten
  #define I2C_SDA               21                //Datapen van de TWI interface
  #define I2C_SCL               22                //Klokpen van de TWI interface
  #define axp_irq_pin           35                         //Ok voor T-Beam V1.0
    
  //Define constants -----------------------------------------------------------
  #define SSD1306_ADDRESS       0x3C
  #define GPS_POWER_CTRL_CH     3        //Kanaal om deze chip te voeden of niet
  #define LORA_POWER_CTRL_CH    2        //Kanaal om deze chip te voeden of niet
  #define PMU_IRQ               35
//END OF PRECOMPILER OPTIONS ---------------------------------------------------


// VOORBEREIDEN SETUP ********************************************************** 
  //Define variables -----------------------------------------------------------
  bool        pmu_irq       = false;
  String      baChStatus    = "Accustatus";
  bool        ssd1306_found = false;
  bool        axp192_found  = false;
  bool        packetSent, packetQueued;
  int         screenW       = 128;
  int         screenH       = 64;
  char buffer[20];
  
  const unsigned char activeSymbol[] PROGMEM = {
    B00000000,
    B00000000,
    B00011000,
    B00100100,
    B01000010,
    B01000010,
    B00100100,
    B00011000
  };

  const unsigned char inactiveSymbol[] PROGMEM = {
    B00000000,
    B00000000,
    B00000000,
    B00000000,
    B00011000,
    B00011000,
    B00000000,
    B00000000
  };

  //Initialize OBJECTS ---------------------------------------------------------
  AXP20X_Class axp;                      //Initialiseer de powerchip bibliotheek
  RTC_DATA_ATTR int bootCount = 0;                         // deep sleep support
  esp_sleep_source_t wakeCause;                // the reason we booted this time
  SSD1306Wire display(SSD1306_ADDRESS, I2C_SDA,I2C_SCL);//T-Beam V1.0 0x3c,21,22
  OLEDDisplayUi ui (&display);    //Vertel de grafische bieb hoe te communiceren

  //Setup van de oled display **************************************************
  void PowerFrame(OLEDDisplay *display, OLEDDisplayUiState* state, int16_t x, int16_t y) {
    display->setTextAlignment(TEXT_ALIGN_CENTER);
    display->setFont(ArialMT_Plain_16);
    display->drawString(62, 25, baChStatus );
  }
  FrameCallback frames[] = {PowerFrame};   //Frames are the single views sliding
  int frameCount = 1;                                //How many frames are there
  //End of setup van de oled display -------------------------------------------
// EINDE VOORBEREIDEN SETUP ----------------------------------------------------


void setup() { //Setup runs once ***********************************************
  Serial.begin(115200);       //Nothing more needed for the Serial Monitor RS232
  Serial.println();                         //Print een lege regel op de monitor

  pinMode(PushButtonPin, INPUT_PULLUP);   //Zet de interne pull-up weerstand aan

  Wire.begin(I2C_SDA, I2C_SCL);                    //Start I2C = TWI bibliotheek
  scanI2Cdevice();                               //Registreer alle TWI apparaten
  axp192Init();                          //Start de bibliotheek van de powerchip
  axp.setChgLEDMode(AXP20X_LED_OFF);                 //Schakel de blauwe LED uit

  ui.setTargetFPS(30);                               //Aantal Frames Per Seconde
  //ui.setActiveSymbol(activeSymbol);             //Customize het active plaatje
  //ui.setInactiveSymbol(inactiveSymbol);       //Customize het inactive plaatje
  ui.setIndicatorPosition(TOP);                       //TOP, LEFT, BOTTOM, RIGHT
  ui.setIndicatorDirection(LEFT_RIGHT);   //Defines where first frame is located
  ui.setFrameAnimation(SLIDE_RIGHT);      //SLIDE_LEFT, SLIDE_UP, SLIDE_DOWN etc
  ui.setFrames(frames, frameCount);                                 //Add frames
  ui.init();                     //Initialising the UI will init the display too

  display.flipScreenVertically();       //Hangt af van hoe de OLED is gemonteerd
  Serial.println("Setup ready, start running loop");        //Melding op monitor
} //End of setup ---------------------------------------------------------------




void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  int remainingTimeBudget = ui.update();            //Lees hoelang de loop loopt
  if (remainingTimeBudget > 0) {                     //You can do some work here
    testAccuCharging();                  //Kijk of de 18650 accu wordt opgeladen
    readPushButton();                           //Kijk of de knop werd ingedrukt
    delay(remainingTimeBudget);    //Don't do stuff if you are below time budget
  } //End if (remainingTimeBudget > 0)                               If is ready
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER




void testAccuCharging() { //Kijk of de 18650 accu wordt opgeladen **************
  if (axp.isChargeing()) {               //Test of de a8650 accu wordt opgeladen
    baChStatus = "Accu laden";   //Laat deze tekst zien als accu wordt opgeladen
    axp.setChgLEDMode(AXP20X_LED_BLINK_4HZ);            //4 blink/sec, high rate
  }else{                                 //Maar als de accu niet wordt opgeladen
    baChStatus = "Accugebruik";                       //Laat dan deze tekst zien
    axp.setChgLEDMode(AXP20X_LED_OFF);                                 //LED off
  } //Einde van if (axp.isChargeing())     Test of de a8650 accu wordt opgeladen
 } // End of testAccuCharging --------------------------------------------------


void readPushButton() { //Lezen en uitvoeren ***********************************
  if (digitalRead(PushButtonPin)) {  //Indien de witte knop niet wordt ingedrukt
      axp.setChgLEDMode(AXP20X_LED_OFF);       //zet dan blauwe LED helemaal uit
  } else {                                //Maar als de knop wel wordt ingedrukt
      axp.setChgLEDMode(AXP20X_LED_LOW_LEVEL);       //zet dan de blauwe LED aan
    } //End of if (digitalRead(PushButtonPin))   //Witte knop uitvoeren is klaar
} // End of readPushButton -----------------------------------------------------


void scanI2Cdevice(void){ //Registreer alle TWI apparaten **********************
    byte err, addr;
    int nDevices = 0;
    for (addr = 1; addr < 127; addr++) {
        Wire.beginTransmission(addr);
        err = Wire.endTransmission();
        if (err == 0) {
            Serial.print("I2C device found at address 0x");
            if (addr < 16)
                Serial.print("0");
            Serial.print(addr, HEX);
            Serial.println(" !");
            nDevices++;

            if (addr == SSD1306_ADDRESS) {
                ssd1306_found = true;
                Serial.println("ssd1306 display found");
            }
            if (addr == AXP192_SLAVE_ADDRESS) {
                axp192_found = true;
                Serial.println("axp192 PMU found");
            }
        } else if (err == 4) {
            Serial.print("Unknow error at address 0x");
            if (addr < 16)
                Serial.print("0");
            Serial.println(addr, HEX);
        }
    }
    if (nDevices == 0)
        Serial.println("No I2C devices found\n");
    else
        Serial.println("done\n");
} //End of scanI2Cdevice(void) ------------------------------------------------






/**
 * Init the power manager chip
 * 
 * axp192 power 
    DCDC1 0.7-3.5V @ 1200mA max -> OLED // If you turn this off you'll lose comms to the axp192 because the
    // OLED and the axp192 share the same i2c bus, instead use ssd1306 sleep mode
    DCDC2 -> unused
    DCDC3 0.7-3.5V @ 700mA max -> ESP32 (keep this on!)
    LDO1 30mA -> charges GPS backup battery // charges the tiny J13 battery by the GPS 
    //to power the GPS ram (for a couple of days), can not be turned off
    LDO2 200mA -> LORA
    LDO3 200mA -> GPS
 */

void axp192Init() {   //https://github.com/kizniche/ttgo-tbeam-ttn-tracker
  if (axp192_found) {
    if (!axp.begin(Wire, AXP192_SLAVE_ADDRESS)) {
      Serial.println("AXP192 Begin PASS");
    } else {
      Serial.println("AXP192 Begin FAIL");
    } //End of if (!axp.begin(Wire, AXP192_SLAVE_ADDRESS))

    Serial.println("---------------------------------------------------------");
    Serial.printf("DCDC1: %s\n", axp.isDCDC1Enable() ? "ENABLE" : "DISABLE");
    Serial.printf("DCDC2: %s\n", axp.isDCDC2Enable() ? "ENABLE" : "DISABLE");
    Serial.printf("LDO2: %s\n",  axp.isLDO2Enable()  ? "ENABLE" : "DISABLE");
    Serial.printf("LDO3: %s\n",  axp.isLDO3Enable()  ? "ENABLE" : "DISABLE");
    Serial.printf("DCDC3: %s\n", axp.isDCDC3Enable() ? "ENABLE" : "DISABLE");
    Serial.printf("Exten: %s\n", axp.isExtenEnable() ? "ENABLE" : "DISABLE");
    Serial.println("---------------------------------------------------------");

    axp.setPowerOutPut(AXP192_LDO2,  AXP202_OFF);    //Zet LORA radio aan of uit
    axp.setPowerOutPut(AXP192_LDO3,  AXP202_OFF);     //Zet GPS power aan of uit
    axp.setPowerOutPut(AXP192_DCDC2, AXP202_OFF);              //Niet in gebruik
    axp.setPowerOutPut(AXP192_EXTEN, AXP202_ON);
    axp.setPowerOutPut(AXP192_DCDC1, AXP202_ON);                  //OLED TWI bus
    axp.setDCDC1Voltage(3300);              //Zet de spanning voor de OLED power

    Serial.printf("DCDC1: %s\n", axp.isDCDC1Enable() ? "ENABLE" : "DISABLE");
    Serial.printf("DCDC2: %s\n", axp.isDCDC2Enable() ? "ENABLE" : "DISABLE");
    Serial.printf("LDO2: %s\n",  axp.isLDO2Enable()  ? "ENABLE" : "DISABLE");
    Serial.printf("LDO3: %s\n",  axp.isLDO3Enable()  ? "ENABLE" : "DISABLE");
    Serial.printf("DCDC3: %s\n", axp.isDCDC3Enable() ? "ENABLE" : "DISABLE");
    Serial.printf("Exten: %s\n", axp.isExtenEnable() ? "ENABLE" : "DISABLE");
    Serial.println("---------------------------------------------------------");

    //axp.setChgLEDMode(AXP20X_LED_OFF);                               //LED off
    //axp.setChgLEDMode(AXP20X_LED_BLINK_1HZ);           //1 blink/sec, low rate
    //axp.setChgLEDMode(AXP20X_LED_BLINK_4HZ);          //4 blink/sec, high rate
    //axp.setChgLEDMode(AXP20X_LED_LOW_LEVEL);                     //LED full on

    pinMode(PMU_IRQ, INPUT_PULLUP);
    attachInterrupt(PMU_IRQ, [] { pmu_irq = true; }, FALLING);
    axp.adc1Enable(AXP202_BATT_CUR_ADC1, 1);
    axp.enableIRQ(AXP202_VBUS_REMOVED_IRQ | AXP202_VBUS_CONNECT_IRQ | AXP202_BATT_REMOVED_IRQ | AXP202_BATT_CONNECT_IRQ, 1);
    axp.clearIRQ();
    if (axp.isChargeing()) {             //Test of de a8650 accu wordt opgeladen
      baChStatus = "Accu laden"; //Laat deze tekst zien als accu wordt opgeladen
    }else{                               //Maar als de accu niet wordt opgeladen
      baChStatus = "Accugebruik";                     //Laat dan deze tekst zien
    } //Einde van if (axp.isChargeing())   Test of de a8650 accu wordt opgeladen
  }else{
    Serial.println("AXP192 not found");
  }
}
