////////////////////////////////////////////////////////////////////////////////
// Name:       ttn-4in1.ino                                                   //
// http://robotigs.nl/robots/includes/parts.php?idpart=364                    //
// Created by: HARB rboek2@gmail.com September 2020 GPL copyrights            //
// Originals:  https://github.com/kizniche/ttgo-tbeam-ttn-tracker             //
//             https://github.com/sidddy/flora                                //
// Platform:   TTGO T-Beam V1.0 / RC8                                         //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
//                                                                            //
// As inputs the following modules are mounted:                               //
//                                                                            //
// For communications and statistics are mounted:                             //
////////////////////////////////////////////////////////////////////////////////

  //Benodigde bibliotheken voor dit programma ----------------------------------
  // https://github.com/mcci-catena/arduino-lmic                             TTN
  // https://github.com/mikalhart/TinyGPSPlus                                GPS
  // https://github.com/ThingPulse/esp8266-oled-ssd1306                     OLED
  // https://github.com/lewisxhe/AXP202X_Library                           POWER

  //Define the needed header files for the precompiler, no charge if not used --
  #include "configuration.h"            //Bevat pin aansluitingen en versies etc
  #include "rom/rtc.h"   //Bibliotheek om bij bepaalde registers te kunnen komen
  #include <TinyGPS++.h>                      //Bevat de programma`s voor de GPS
  #include <Wire.h>                          //De standaard bibliotheek voor IIC
  #include "axp20x.h"            //Biliotheek met programma`s voor de power chip
  #include "BLEDevice.h"      //BLE code is now included in Arduino IDE directly

  //Define PINS ----------------------------------------------------------------
  //Define EEPROM variables ----------------------------------------------------
  //Define DATABASE VARIABLES --------------------------------------------------
  //Define variables -----------------------------------------------------------
  static int deviceCount = sizeof FLORA_DEVICES / sizeof FLORA_DEVICES[0];
  static BLEUUID serviceUUID("00001204-0000-1000-8000-00805f9b34fb");
  static BLEUUID uuid_version_battery("00001a02-0000-1000-8000-00805f9b34fb");
  static BLEUUID uuid_sensor_data("00001a01-0000-1000-8000-00805f9b34fb");
  static BLEUUID uuid_write_mode("00001a00-0000-1000-8000-00805f9b34fb");

  TaskHandle_t hibernateTaskHandle = NULL;

  bool   pmu_irq = false;
  String baChStatus = "No charging";
  bool   ssd1306_found = false;
  bool   axp192_found = false;
  bool   packetSent, packetQueued;
  #if defined(PAYLOAD_USE_FULL)                     //Defined in configuration.h
    static uint8_t txBuffer[10];
  #elif defined(PAYLOAD_USE_CAYENNE)   //CAYENNE DF
    static uint8_t txBuffer[11] = {0x03, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  #endif
  RTC_DATA_ATTR int bootCount = 0; // deep sleep support
  esp_sleep_source_t wakeCause; // the reason we booted this time
  hw_timer_t * timer = NULL;                           //Create a hardware timer
  bool readBattery = ((bootCount % BATTERY_INTERVAL) == 0); //check if battery status should be read-based on boot count

  //Initialize OBJECTS ---------------------------------------------------------
  AXP20X_Class axp;                          //Maak een object voor de powerchip

  void IRAM_ATTR onTimer(){                         //Callback routine ieder half uur 60*30=1800
    Serial.print("Doe hier ietz ");
    Serial.println("Dit is de routine als de timer klaar is...");
    BLEDevice::init("Op dit moment enkel 4in1. We wachten op TTN");
    BLEDevice::setPower(ESP_PWR_LVL_P7);
    for (int i=0; i<deviceCount; i++) {  // process devices
      int tryCount = 0;
      char* deviceMacAddress = FLORA_DEVICES[i];
      BLEAddress floraAddress(deviceMacAddress);
      while (tryCount < RETRY) {
        tryCount++;
        if (processFloraDevice(floraAddress, deviceMacAddress, readBattery, tryCount)) {
          break;
        } //End of if 
        delay(1000);
      } //End of while
      delay(1500);
    } //End of for
  } //End of callback
  

void setup() { //Setup runs once ***********************************************
  pinMode(BUTTON_PIN, INPUT_PULLUP);                           //Button initiate
  Serial.begin(115200);              //Start seriele output voor seriele monitor
  Serial.println("Setup");       //Laat de gebruiker zien waar we mee bezig zijn

  //Start objects --------------------------------------------------------------
  initDeepSleep();          //Perform power on init on each wake from deep sleep
  Wire.begin(I2C_SDA, I2C_SCL);  //Initiate the TWI/IIC interface Oled & PowerIC
  scanI2Cdevice();                           //Zet ssd1306_found en axp192_found
  axp192Init();                                         //Set LED and powerlines
  DEBUG_MSG(APP_NAME " " APP_VERSION "\n");       //Variables in Configuration.h

  if (wakeCause == ESP_SLEEP_WAKEUP_TIMER) {    //Don't init if on a timer event
    ssd1306_found = false;                    //Forget we even have the hardware
  } //End of if (wakeCause == ESP_SLEEP_WAKEUP_TIMER)

  if (ssd1306_found) {                       //Only initialise if we have a Oled
    screen_setup();
  } //End of if (ssd1306_found)


  if (bootCount == 0) {         //Show logo on first boot after removing battery
    screen_print(APP_NAME " " APP_VERSION, 0, 0);
    screen_show_logo();
    screen_update();
    delay(LOGO_DELAY);
  } //End of if (bootCount == 0)

  gps_setup();                                              //Zie in tabblad GPS
  while (gps_sats() < 3){     //Controleer dat de GPS ontvangst goed is GPS LOCK
    gps_loop();
    Serial.println("Waiting GPS lock\n");
    delay(100);             //Don't just keep spinning in loop as fast as we can
  }

  Serial.println("Initialize TTN...");
  if (!ttn_setup()) {                                                //TTN setup
    screen_print("[ERR] Radio module not found!\n");
    if (REQUIRE_RADIO) {
      delay(MESSAGE_TO_SLEEP_DELAY);
      screen_off();
      sleep_forever();
    } //End of if (REQUIRE_RADIO)
  } else { //Else of if (!ttn_setup())
    ttn_register(callback);
    ttn_join();
    ttn_adr(LORAWAN_ADR);
  } //End of if (!ttn_setup())

  bootCount++;                                             //Increase boot count
  // xTaskCreate(delayedHibernate, "hibernate", 1096, NULL, 1, &hibernateTaskHandle); // create a hibernate task in case something gets stuck

  Serial.println("Initialize BLE client...");
  BLEDevice::init("4in1");
  BLEDevice::setPower(ESP_PWR_LVL_P7);
  bool readBattery = ((bootCount % BATTERY_INTERVAL) == 0);   // check if battery status should be read - based on boot count

  for (int i=0; i<deviceCount; i++) {  // process devices
    int tryCount = 0;
    char* deviceMacAddress = FLORA_DEVICES[i];
    BLEAddress floraAddress(deviceMacAddress);

    while (tryCount < RETRY) {
      tryCount++;
      if (processFloraDevice(floraAddress, deviceMacAddress, readBattery, tryCount)) {
        break;
      }
      delay(1000);
    }
    delay(1500);
  }
  //vTaskDelete(hibernateTaskHandle);   // delete emergency hibernate task
  //hibernate();                        // go to sleep now
  

  timer = timerBegin(0, 8000, true);             //Use 1st timer of 4, 1 tick takes 1/(80MHZ/80) = 1us, count up
  timerAttachInterrupt(timer, &onTimer, true);    //Attach onTimer function to our timer
  timerAlarmWrite(timer, 18000000, true);          //Set alarm to call onTimer function, 1 second is 1000000us, Repeat the alarm
  timerAlarmEnable(timer);      
} //End of setup ---------------------------------------------------------------








void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  //while (GPS.available()) { gps.encode(GPS.read()); }    //Haal als GPS spuugt
  gps_loop();
  ttn_loop();                              //= os_runloop_once(); in tabblad ttn
  screen_loop();            //Kijkt of de accu aan het laden is en laat dit zien

  if (packetSent) {                                 //Wordt gezet in buildPacket
    packetSent = false;               //Was met succes dus nu kunnen we resetten
    //sleep();                                             \//Die doen we ff uit
  } //End of if (packetSent)

  static uint32_t last = 0;                    //Send every SEND_INTERVAL millis
  static bool first = true;       //Laat enkel de eerste keer een boodschap zien
  if (0 == last || millis() - last > SEND_INTERVAL) {
    if (trySend()) {
      last = millis();
      first = false;
      Serial.println("TRANSMITTED");
    } else {
      if (first) {
        screen_print("Waiting GPS lock\n");
        first = false;
      } //End of if (first)
      // No GPS lock yet, let the OS put the main CPU in low power mode for 100ms (or until another interrupt comes in)
      Serial.println("Waiting GPS lock\n");
      delay(100);           //Don't just keep spinning in loop as fast as we can
    }
  }
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER




void buildPacket(uint8_t txBuffer[]); //Zend de data naar TTN ******************
  bool trySend() {           //If we have a valid position send it to the server
    packetSent = false;                     //@return true if we decided to send
    if (0 < gps_hdop() && gps_hdop() < 50 && gps_latitude() != 0 && gps_longitude() != 0 && gps_altitude() != 0) {
      char buffer[40];  //Also wait for altitude being not exactly zero, GPS chip generates a bogus 0 alt when first powered on
      snprintf(buffer, sizeof(buffer), "Latitude: %10.6f\n", gps_latitude());
      screen_print(buffer);
      snprintf(buffer, sizeof(buffer), "Longitude: %10.6f\n", gps_longitude());
      screen_print(buffer);
      snprintf(buffer, sizeof(buffer), "Error: %4.2fm\n", gps_hdop());
      screen_print(buffer);
      buildPacket(txBuffer);
      #if LORAWAN_CONFIRMED_EVERY > 0
        bool confirmed = (count % LORAWAN_CONFIRMED_EVERY == 0);
      #else
        bool confirmed = false;
      #endif
      packetQueued = true;
      ttn_send(txBuffer, sizeof(txBuffer), LORAWAN_PORT, confirmed);
      return true;
  } else { //Else of bool trySend()
      return false;
  } //End of  bool trySend()
} //End of void buildPacket(uint8_t txBuffer[]); -----------------------------



void initDeepSleep() { //Perform power on init on each wake from deep sleep **
  bootCount++;
  wakeCause = esp_sleep_get_wakeup_cause(); 
  //Not using yet because we are using wake on all buttons being low
  /* 
    wakeButtons = esp_sleep_get_ext1_wakeup_status();       // If one of these buttons is set it was the reason we woke
    if (wakeCause == ESP_SLEEP_WAKEUP_EXT1 && !wakeButtons) // we must have been using the 'all buttons rule for waking' 
                                                            // to support busted boards, assume button one was pressed
        wakeButtons = ((uint64_t)1) << buttons.gpios[0];
  */
  Serial.printf("booted, wake cause %d (boot count %d)\n", wakeCause, bootCount);
} //End of initDeepSleep() -----------------------------------------------------




void doDeepSleep(uint64_t msecToWake) { //**************************************
  Serial.printf("Entering deep sleep for %llu seconds\n", msecToWake / 1000);
  //Not using wifi yet, but if we are this is needed to shutoff the radio hw
  //esp_wifi_stop();
  screen_off();                        //Datasheet says this will draw only 10ua
  LMIC_shutdown();                              //Cleanly shutdown the LoRaradio
  if(axp192_found) {         // turn on after initial testing with real hardware
    axp.setPowerOutPut(AXP192_LDO2, AXP202_OFF);                    //LORA radio
    axp.setPowerOutPut(AXP192_LDO3, AXP202_OFF);                //GPS main power
  } //End of if(axp192_found)
  //FIXME - use an external 10k pulldown so we can leave the RTC peripherals powered off
  // until then we need the following lines
  esp_sleep_pd_config(ESP_PD_DOMAIN_RTC_PERIPH, ESP_PD_OPTION_ON);
  //Only GPIOs which are have RTC functionality can be used in this bit map: 0,2,4,12-15,25-27,32-39.
  uint64_t gpioMask = (1ULL << BUTTON_PIN);
  //FIXME change polarity so we can wake on ANY_HIGH instead - that would allow us to use all three buttons (instead of just the first)
  gpio_pullup_en((gpio_num_t) BUTTON_PIN);
  esp_sleep_enable_ext1_wakeup(gpioMask, ESP_EXT1_WAKEUP_ALL_LOW);
  esp_sleep_enable_timer_wakeup(msecToWake * 1000ULL);              //Call expects usecs
  esp_deep_sleep_start();                                //TBD mA sleep current (battery)
} //End of void doDeepSleep -------------------------------------------------------------




void sleep() {
#if SLEEP_BETWEEN_MESSAGES

  // If the user has a screen, tell them we are about to sleep
  if (ssd1306_found) {
    // Show the going to sleep message on the screen
    char buffer[20];
    snprintf(buffer, sizeof(buffer), "Sleeping in %3.1fs\n", (MESSAGE_TO_SLEEP_DELAY / 1000.0));
    screen_print(buffer);

    // Wait for MESSAGE_TO_SLEEP_DELAY millis to sleep
    delay(MESSAGE_TO_SLEEP_DELAY);

    // Turn off screen
    screen_off();
  }

  // Set the user button to wake the board
  sleep_interrupt(BUTTON_PIN, LOW);

  // We sleep for the interval between messages minus the current millis
  // this way we distribute the messages evenly every SEND_INTERVAL millis
  uint32_t sleep_for = (millis() < SEND_INTERVAL) ? SEND_INTERVAL - millis() : SEND_INTERVAL;
  doDeepSleep(sleep_for);

#endif
}




void callback(uint8_t message) {
  if (EV_JOINING == message) screen_print("Joining TTN...\n");
  if (EV_JOINED == message) {
    screen_print("TTN joined!\n");
  }
  if (EV_JOIN_FAILED == message) screen_print("TTN join failed\n");
  if (EV_REJOIN_FAILED == message) screen_print("TTN rejoin failed\n");
  if (EV_RESET == message) screen_print("Reset TTN connection\n");
  if (EV_LINK_DEAD == message) screen_print("TTN link dead\n");
  if (EV_ACK == message) screen_print("ACK received\n");
  if (EV_PENDING == message) screen_print("Message discarded\n");
  if (EV_QUEUED == message) screen_print("Message queued\n");

  // We only want to say 'packetSent' for our packets (not packets needed for joining)
  if (EV_TXCOMPLETE == message && packetQueued) {
    screen_print("Message sent\n");
    packetQueued = false;
    packetSent = true;
  }

  if (EV_RESPONSE == message) {
    screen_print("[TTN] Response: ");
    size_t len = ttn_response_len();
    uint8_t data[len];
    ttn_response(data, len);
    char buffer[6];
    for (uint8_t i = 0; i < len; i++) {
      snprintf(buffer, sizeof(buffer), "%02X", data[i]);
      screen_print(buffer);
    }
    screen_print("\n");
  }
}



////////////////////////////////////////////////////////////////////////////////
void scanI2Cdevice(void) { //Zet ssd1306_found en axp192_found *****************
  byte err, addr;
  int nDevices = 0;
    for (addr = 1; addr < 127; addr++) {
        Wire.beginTransmission(addr);
        err = Wire.endTransmission();
        if (err == 0) {
            Serial.print("I2C device found at address 0x");
            if (addr < 16)
                Serial.print("0");
            Serial.print(addr, HEX);
            Serial.println(" !");
            nDevices++;

            if (addr == SSD1306_ADDRESS) {
                ssd1306_found = true;
                Serial.println("ssd1306 display found");
            }
            if (addr == AXP192_SLAVE_ADDRESS) {
                axp192_found = true;
                Serial.println("axp192 PMU found");
            }
        } else if (err == 4) {
            Serial.print("Unknow error at address 0x");
            if (addr < 16)
                Serial.print("0");
            Serial.println(addr, HEX);
        }
    }
    if (nDevices == 0)
        Serial.println("No I2C devices found\n");
    else
        Serial.println("done\n");
}





/**
 * Init the power manager chip
 * 
 * axp192 power 
    DCDC1 0.7-3.5V @ 1200mA max -> OLED // If you turn this off you'll lose comms to the axp192 because the OLED
    //and the axp192 share the same i2c bus, instead use ssd1306 sleep mode
    DCDC2 -> unused
    DCDC3 0.7-3.5V @ 700mA max -> ESP32 (keep this on!)
    LDO1 30mA -> charges GPS backup battery // charges the tiny J13 battery by the GPS to power the GPS ram (for a couple of days)
    //, can not be turned off
    LDO2 200mA -> LORA
    LDO3 200mA -> GPS
 */

void axp192Init() { //Set LED and powerlines ***********************************
    if (axp192_found) {                         //This is set in scanI2Cdevice()
        if (!axp.begin(Wire, AXP192_SLAVE_ADDRESS)) {
            Serial.println("AXP192 Begin PASS");
        } else {
            Serial.println("AXP192 Begin FAIL");
        }
        // axp.setChgLEDMode(LED_BLINK_4HZ);
        Serial.printf("DCDC1: %s\n", axp.isDCDC1Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("DCDC2: %s\n", axp.isDCDC2Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("LDO2: %s\n", axp.isLDO2Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("LDO3: %s\n", axp.isLDO3Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("DCDC3: %s\n", axp.isDCDC3Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("Exten: %s\n", axp.isExtenEnable() ? "ENABLE" : "DISABLE");
        Serial.println("----------------------------------------");

        axp.setPowerOutPut(AXP192_LDO2, AXP202_ON); // LORA radio
        axp.setPowerOutPut(AXP192_LDO3, AXP202_ON); // GPS main power
        axp.setPowerOutPut(AXP192_DCDC2, AXP202_ON);
        axp.setPowerOutPut(AXP192_EXTEN, AXP202_ON);
        axp.setPowerOutPut(AXP192_DCDC1, AXP202_ON);
        axp.setDCDC1Voltage(3300); // for the OLED power

        Serial.printf("DCDC1: %s\n", axp.isDCDC1Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("DCDC2: %s\n", axp.isDCDC2Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("LDO2: %s\n", axp.isLDO2Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("LDO3: %s\n", axp.isLDO3Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("DCDC3: %s\n", axp.isDCDC3Enable() ? "ENABLE" : "DISABLE");
        Serial.printf("Exten: %s\n", axp.isExtenEnable() ? "ENABLE" : "DISABLE");

        //axp.setChgLEDMode(AXP20X_LED_OFF); // LED off
        //axp.setChgLEDMode(AXP20X_LED_BLINK_1HZ); // 1blink/sec, low rate
        //axp.setChgLEDMode(AXP20X_LED_BLINK_4HZ); // 4blink/sec, high rate
        //axp.setChgLEDMode(AXP20X_LED_LOW_LEVEL); // LED full on

        pinMode(PMU_IRQ, INPUT_PULLUP);
        attachInterrupt(PMU_IRQ, [] {
            pmu_irq = true;
        }, FALLING);

        axp.adc1Enable(AXP202_BATT_CUR_ADC1, 1);
        axp.enableIRQ(AXP202_VBUS_REMOVED_IRQ | AXP202_VBUS_CONNECT_IRQ | AXP202_BATT_REMOVED_IRQ | AXP202_BATT_CONNECT_IRQ, 1);
        axp.clearIRQ();

        if (axp.isChargeing()) {
            baChStatus = "Charging";
        }
    } else {
        Serial.println("AXP192 not found");
    }
} //End of axp192Init ----------------------------------------------------------






BLEClient* getFloraClient(BLEAddress floraAddress) {
  BLEClient* floraClient = BLEDevice::createClient();
  if (!floraClient->connect(floraAddress)) {
    Serial.println("- Connection failed, skipping");
    return nullptr;
  }
  Serial.println("- Connection successful");
  return floraClient;
}



BLERemoteService* getFloraService(BLEClient* floraClient) {
  BLERemoteService* floraService = nullptr;
  try { floraService = floraClient->getService(serviceUUID);  }
  catch (...) {  }     // something went wrong
  if (floraService == nullptr) {
    Serial.println("- Failed to find data service");
  } else {
    Serial.println("- Found data service");
  }
  return floraService;
}



bool forceFloraServiceDataMode(BLERemoteService* floraService) {
  BLERemoteCharacteristic* floraCharacteristic;
  Serial.println("- Force device in data mode");   // get device mode characteristic, needs to be changed to read data
  floraCharacteristic = nullptr;
  try { floraCharacteristic = floraService->getCharacteristic(uuid_write_mode); }
  catch (...) {  }     // something went wrong
  if (floraCharacteristic == nullptr) {
    Serial.println("-- Failed, skipping device");
    return false;
  }
  uint8_t buf[2] = {0xA0, 0x1F};   // write the magic data
  floraCharacteristic->writeValue(buf, 2, true);
  delay(500);
  return true;
}



bool readFloraDataCharacteristic(BLERemoteService* floraService, String baseTopic) {
  BLERemoteCharacteristic* floraCharacteristic = nullptr;

  Serial.println("- Access characteristic from device");   // get the main device data characteristic
  try { floraCharacteristic = floraService->getCharacteristic(uuid_sensor_data);  }
  catch (...) { }     // something went wrong
  if (floraCharacteristic == nullptr) {
    Serial.println("-- Failed, skipping device");
    return false;
  }

  Serial.println("- Read value from characteristic");   // read characteristic value
  std::string value;
  try{ value = floraCharacteristic->readValue();  }
  catch (...) {          // something went wrong
    Serial.println("-- Failed, skipping device"); 
    return false;
  }
  const char *val = value.c_str();
  Serial.print("Hex: ");
  for (int i = 0; i < 16; i++) {
    Serial.print((int)val[i], HEX);
    Serial.print(" ");
  }
  Serial.println(" ");

  int16_t* temp_raw = (int16_t*)val;
  float temperature = (*temp_raw) / ((float)10.0);
  Serial.print(" Temperatuur: ");
  Serial.println(temperature);

  int moisture = val[7];
  Serial.print("-- Moisture: ");
  Serial.println(moisture);

  int light = val[3] + val[4] * 256;
  Serial.print("-- Light: ");
  Serial.println(light);
 
  int conductivity = val[8] + val[9] * 256;
  Serial.print("-- Conductivity: ");
  Serial.println(conductivity);

  if (temperature > 200) {
    Serial.println("-- Unreasonable values received, skip publish");
    return false;
  }
  return true;
}




bool readFloraBatteryCharacteristic(BLERemoteService* floraService, String baseTopic) {
  BLERemoteCharacteristic* floraCharacteristic = nullptr;

  Serial.println("- Access battery characteristic from device");   // get the device battery characteristic
  try {
    floraCharacteristic = floraService->getCharacteristic(uuid_version_battery);
  }
  catch (...) {
    // something went wrong
  }
  if (floraCharacteristic == nullptr) {
    Serial.println("-- Failed, skipping battery level");
    return false;
  }

  // read characteristic value
  Serial.println("- Read value from characteristic");
  std::string value;
  try{
    value = floraCharacteristic->readValue();
  }
  catch (...) {
    // something went wrong
    Serial.println("-- Failed, skipping battery level");
    return false;
  }
  const char *val2 = value.c_str();
  int battery = val2[0];

  char buffer[64];

  Serial.print("-- Battery: ");
  Serial.println(battery);
  return true;
}




bool processFloraService(BLERemoteService* floraService, char* deviceMacAddress, bool readBattery) {
  if (!forceFloraServiceDataMode(floraService)) {   //Set device in data mode
    return false;
  }
  String baseTopic = BASE_TOPIC + "/" + deviceMacAddress + "/";
  bool dataSuccess = readFloraDataCharacteristic(floraService, baseTopic);
  bool batterySuccess = true;
  if (readBattery) {
    batterySuccess = readFloraBatteryCharacteristic(floraService, baseTopic);
  }
  return dataSuccess && batterySuccess;
}




bool processFloraDevice(BLEAddress floraAddress, char* deviceMacAddress, bool getBattery, int tryCount) {
  Serial.print("Processing Flora device at ");
  Serial.print(floraAddress.toString().c_str());
  Serial.print(" (try ");
  Serial.print(tryCount);
  Serial.println(")");

  BLEClient* floraClient = getFloraClient(floraAddress);   //Connect to flora ble server
  if (floraClient == nullptr) {
    return false;
  }

  // connect data service
  BLERemoteService* floraService = getFloraService(floraClient);
  if (floraService == nullptr) {
    floraClient->disconnect();
    return false;
  }
  bool success = processFloraService(floraService, deviceMacAddress, getBattery);   // process devices data
  floraClient->disconnect();   // disconnect from device
  return success;
}







void hibernate() {
  esp_sleep_enable_timer_wakeup(SLEEP_DURATION * 1000000ll);
  Serial.println("Going to sleep now.");
  delay(100);
  esp_deep_sleep_start();
}



void delayedHibernate(void *parameter) {
  delay(EMERGENCY_HIBERNATE*1000); // delay for five minutes
  Serial.println("Something got stuck, entering emergency hibernate...");
  hibernate();
}
