/* 

Credentials file

*/

#pragma once

// Only one of these settings must be defined
//#define USE_ABP
#define USE_OTAA


#ifdef USE_OTAA

    // This EUI must be in little-endian format, so least-significant-byte
    // first. When copying an EUI from ttnctl output, this means to reverse
    // the bytes.
    // Note: You do not need to set this field, if unset it will be generated automatically
    // based on the device macaddr
    static u1_t DEVEUI[8]  = { 0x59, 0xB6, 0x8E, 0x22, 0xE3, 0x43, 0x49, 0x00 };
             //Origineel 1 = { 0x00, 0xDB, 0x3A, 0xF9, 0xBB, 0x0D, 0x30, 0x2F } 
             //Origineel 2 =   0x00, 0x49, 0x43, 0xE3, 0x22, 0x8E, 0xB6, 0x59  
                      //   = { 0x59, 0xB6, 0x8E, 0x22, 0xE3, 0x43, 0x49, 0x00 };



    // This EUI must be in little-endian format, so least-significant-byte
    // first. When copying an EUI from ttnctl output, this means to reverse
    // the bytes. 
    static const u1_t PROGMEM APPEUI[8]  = { 0x4B, 0x3F, 0x03, 0xD0, 0x7E, 0xD5, 0xB3, 0x70 };

                   
    // This key should be in big endian format (or, since it is not really a
    // number but a block of memory, endianness does not really apply). In
    // practice, a key taken from ttnctl can be copied as-is.
    // The key shown here is the semtech default key.
    static const u1_t PROGMEM APPKEY[16] = { 0x41, 0x70, 0x1A, 0xF4, 0x7E, 0x6B, 0x1E, 0x79, 0xCE, 0xDC, 0xEC, 0x11, 0x57, 0x4D, 0xB6, 0xFE };

#endif




#ifdef USE_ABP

    // LoRaWAN NwkSKey, network session key
    static const u1_t PROGMEM NWKSKEY[16] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
    // LoRaWAN AppSKey, application session key
    static const u1_t PROGMEM APPSKEY[16] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
    // LoRaWAN end-device address (DevAddr)
    // This has to be unique for every node
    static const u4_t DEVADDR = 0x00000000;

#endif
