#include <Arduino.h>
#define LED1_PIN 23
#define LED2_PIN 19
#define LED3_PIN 22
#define LED4_PIN 0
#define LED5_PIN 18

void setup() {
  pinMode(LED1_PIN, OUTPUT);
  pinMode(LED2_PIN, OUTPUT);
  pinMode(LED3_PIN, OUTPUT);
  pinMode(LED4_PIN, OUTPUT);
  pinMode(LED5_PIN, OUTPUT);
}

void loop() {
  digitalWrite(LED1_PIN, !digitalRead(LED1_PIN));
  delay(1000);
  digitalWrite(LED2_PIN, !digitalRead(LED2_PIN));
  delay(1000);
  digitalWrite(LED3_PIN, !digitalRead(LED3_PIN));
  delay(1000);
  digitalWrite(LED4_PIN, !digitalRead(LED4_PIN));
  delay(1000);
  digitalWrite(LED5_PIN, !digitalRead(LED5_PIN));
  delay(1000);
}


////////////////////////////////////////////////////////////////////////////////
// PIN ALLOCATIONS TABLE HELTEC WIFILORA 32 V1                                //
// GPIO - Function    - External Connection                              FUNC //
//                                                                            //
//    0 - Push button - Internally connected                          GPO PPG //
//    2 - ADC2_2      - HSPI-WP ONBOARD LED                               LED //
//    4 - ADC2_0      - HSPI-HD TOUCH0                               GPIO ADC //
//    5 - LoRa_Sck    - VSPI-CSO Input is LoRa_Sck                    GPO SPI //
//   12 - ADC2_5      - TOUCH5                                       GPIO ADC //
//   13 - ADC2_4      - TOUCH4                                       GPIO ADC //
//   15 - ADC2_3      - HSPI-CSO TOUCH3                              GPIO ADC //
//   17 - ADC2_4      - U2_TXD                                       GPIO TXD //
//   18 - LoRa_Cs     - VSPI-CLK Input is LoRa_Cs                     GPO SPI //
//   19 - LoRa_MiSO   - VSPI-Q Input is LoRa_MiSo U0_CTS              GPO SPI //
//   21 - SDA         - Input is Vext control                         GPO TWI //
//   22 - SCL         - VSPI-WP U0_RTS                               GPIO TWI //
//   23 - V_SPI_D     -                                               GPO SPI //
//   32 - XTAL32      - INPUT ONLY                                        ADC //
//   33 - XTAL32      - INPUT ONLY                                        ADC //
//   36 - ADC1_0      - INPUT ONLY                                        ADC //
//   37 - ADC1_1      - INPUT ONLY                                        ADC //
//   38 - ADC1_2      - INPUT ONLY                                        ADC //
//   39 - ADC1_3      - INPUT ONLY                                        ADC //
////////////////////////////////////////////////////////////////////////////////
