////////////////////////////////////////////////////////////////////////////////
// Naam:       HT32_Clock.ino                                                 //
//             http://robotigs.com/robots/includes/parts.php?idpart=113#rnt   //
//                                                                            //
// Created by: HARB rboek2@gmail.com januar 2021 GPL copyrights               //
// Origineel:  https://randomnerdtutorials.com (zie onder)                    //
// Platform:   Helltec WifiLoRa 32                                            //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
// - Oled schermpje ,monochroom 128x64                                        //
//            http://robotigs.nl/robots/includes/parts.php?idpart=43          //
//                                                                            //
// As inputs the following modules are mounted:                               //
//                                                                            //
// For communications and statistics are mounted:                             //
// - Standard Serial Monitor output                                           //
//            http://robotigs.nl/robots/includes/parts.php?idpart=43          //
////////////////////////////////////////////////////////////////////////////////

// SET PRECOMPILER OPTIONS *****************************************************
  //Define the needed header files for the precompiler, no charge if not used --
  #include <WiFi.h>                  //Standaard geinstalleerd in de Arduino IDE
  #include <time.h>                  //Standaard geinstalleerd in de Arduino IDE

  //Define PINS ----------------------------------------------------------------
  #define ledOnBoardPin   2           //Pen waarop de onboard LED is aangesloten
  #define touch5Pin      12       //Pen waarop touch5 electronica is aangesloten

  //Define EEPROM variables ----------------------------------------------------
  //Define DATABASE VARIABLES --------------------------------------------------
  
  //Define variables -----------------------------------------------------------
  bool ledOnBoardVal             = 0;              //Toggelt om LED te schakelen
  const char* ssid               = "REPLACE_WITH_YOUR_SSID";
  const char* password           = "REPLACE_WITH_YOUR_PASSWORD";
  const char* ntpServer          = "pool.ntp.org";
  const long  gmtOffset_sec      = 0;
  const int   daylightOffset_sec = 3600;
  //Initialize OBJECTS ---------------------------------------------------------
//END OF PRECOMPILER OPTIONS ---------------------------------------------------




void setup() { //Setup runs once ***********************************************
  Serial.begin(115200);       //Nothing more needed for the Serial Monitor RS232
  while (!Serial);                //Wacht totdat de seriele poort is geactiveerd
  Serial.println("ESP32 Clock Test");    //Geef berichtje via de seriele monitor
  pinMode(ledOnBoardPin, OUTPUT);                //Board contains an onboard LED
  
  //Start objects --------------------------------------------------------------
  Serial.print("Connecting to ");                             //Verbind met WiFi
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connected.");

  configTime(gmtOffset_sec, daylightOffset_sec, ntpServer);  //Init and get time
  printLocalTime();

  //Test hardware and software -------------------------------------------------
} //End of setup ---------------------------------------------------------------





void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  delay(11000);                                              //Wacht 11 seconden
  printLocalTime();                    //Print tijd uit timer op seriele monitor
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER



void printLocalTime(){ //Print tijd uit timer op seriele monitor ***************
  struct tm timeinfo;
  if(!getLocalTime(&timeinfo)){
    Serial.println("Failed to obtain time");
    return;
  }
  Serial.println(&timeinfo, "%A, %B %d %Y %H:%M:%S");
  Serial.print("Day of week: ");
  Serial.println(&timeinfo, "%A");
  Serial.print("Month: ");
  Serial.println(&timeinfo, "%B");
  Serial.print("Day of Month: ");
  Serial.println(&timeinfo, "%d");
  Serial.print("Year: ");
  Serial.println(&timeinfo, "%Y");
  Serial.print("Hour: ");
  Serial.println(&timeinfo, "%H");
  Serial.print("Hour (12 hour format): ");
  Serial.println(&timeinfo, "%I");
  Serial.print("Minute: ");
  Serial.println(&timeinfo, "%M");
  Serial.print("Second: ");
  Serial.println(&timeinfo, "%S");

  Serial.println("Time variables");
  char timeHour[3];
  strftime(timeHour,3, "%H", &timeinfo);
  Serial.println(timeHour);
  char timeWeekDay[10];
  strftime(timeWeekDay,10, "%A", &timeinfo);
  Serial.println(timeWeekDay);
  Serial.println();
} //End of void printLocalTime() -----------------------------------------------


void toggle_ledOnBoard(void){ //Togglet de ledOnBoardVal van ledOnBoard ********
  ledOnBoardVal = !ledOnBoardVal;                                 //Toggle value
  digitalWrite(ledOnBoardPin, ledOnBoardVal);           //Set boards onboard LED
} //Exit toggle_ledOnBoard -----------------------------------------------------



void close_WiFi(void){ //Disconnect WiFi as it's no longer needed **************
  WiFi.disconnect(true);
  WiFi.mode(WIFI_OFF);
} //Exit close_WiFi ------------------------------------------------------------




////////////////////////////////////////////////////////////////////////////////
// PIN ALLOCATIONS TABLE HELTEC WIFILORA 32 V1                                //
// GPIO - Function    - External Connection                              FUNC //
//                                                                            //
//    0 - Push button - Internally connected                          GPO PPG //
//    2 - ADC2_2      - HSPI-WP ONBOARD LED                               LED //
//    4 - ADC2_0      - HSPI-HD TOUCH0                               GPIO ADC //
//    5 - LoRa_Sck    - VSPI-CSO Input is LoRa_Sck                    GPO SPI //
//   12 - ADC2_5      - TOUCH5                                       GPIO ADC //
//   13 - ADC2_4      - TOUCH4                                       GPIO ADC //
//   15 - ADC2_3      - HSPI-CSO TOUCH3                              GPIO ADC //
//   17 - ADC2_4      - U2_TXD                                       GPIO TXD //
//   18 - LoRa_Cs     - VSPI-CLK Input is LoRa_Cs                     GPO SPI //
//   19 - LoRa_MiSO   - VSPI-Q Input is LoRa_MiSo U0_CTS              GPO SPI //
//   21 - SDA         - Input is Vext control                         GPO TWI //
//   22 - SCL         - VSPI-WP U0_RTS                               GPIO TWI //
//   23 - V_SPI_D     -                                               GPO SPI //
//   32 - XTAL32      - INPUT ONLY                                        ADC //
//   33 - XTAL32      - INPUT ONLY                                        ADC //
//   36 - ADC1_0      - INPUT ONLY                                        ADC //
//   37 - ADC1_1      - INPUT ONLY                                        ADC //
//   38 - ADC1_2      - INPUT ONLY                                        ADC //
//   39 - ADC1_3      - INPUT ONLY                                        ADC //
////////////////////////////////////////////////////////////////////////////////
