////////////////////////////////////////////////////////////////////////////////
// Naam:       HT32_Couveuse1.ino                                             //
//             http://robotigs.nl/robots/includes/bots.php?idbot=17           //
//                                                                            //
// Created by: HARB rboek2@gmail.com march 2021 GPL copyrights                //
// Origineel:  https://randomnerdtutorials.com (zie onder)                    //
// Platform:   Helltec WifiLoRa 32                                            //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
// - Standard Onboard LED                                                     //
//           http://robotigs.nl/robots/includes/parts.php?idpart=185          //
// - LED display 4 * 7 segmenten met punten en dubble punt                    //
//            http://robotigs.nl/robots/includes/parts.php?idpart=356         //
// - Activ loudspeaker / buzzer                                               //
//           http://robotigs.nl/robots/includes/parts.php?idpart=240          //
// - 220 Vac Relay                                                            //
//           http://robotigs.nl/robots/includes/parts.php?idpart=189          //
//                                                                            //
// As inputs the following modules are mounted:                               //
// - Temp DS18B20                                                             //
//           http://robotigs.nl/robots/includes/parts.php?idpart=180          //
//                                                                            //
// For communications and statistics are mounted:                             //
// - Standard Serial Monitor output                                           //
//            http://robotigs.nl/robots/includes/parts.php?idpart=43          //
////////////////////////////////////////////////////////////////////////////////

  //Define VARIABLE SETTINGS ---------------------------------------------------
  String        deviceID         = "couveuse2";  //Plaats hier naam van couveuse
  const char*   ssid             = "H369AAA781A";          //Plaats hier je SSID
  const char*   password         = "DD7D5CAAA3DE";     //Plaats hier je password
  const char*   mqttServer       = "192.168.2.24";        //Mqtt server IP adres

// SET PRECOMPILER OPTIONS *****************************************************
  //Define the needed header files for the precompiler, no charge if not used --
  #include <EEPROM.h>                //Standaard geinstalleerd in de Arduino IDE
  #include <WiFi.h>                  //Standaard geinstalleerd in de Arduino IDE
  #include <OneWire.h> //Meegeleverd met Arduino IDE maar nog niet geinstalleerd
  #include <NTPClient.h>   //Meegeleverd met Arduino IDE maar niet geinstalleerd
  #include <Adafruit_GFX.h>    //Meegeleverd met Arduino IDE, niet geinstalleerd
  #include <Adafruit_LEDBackpack.h>            //Meegeleverd, niet geinstalleerd
  #include <DS18B20.h>               //https://github.com/RobTillaart/DS18B20_RT
  #include <PubSubClient.h>          //https://github.com/knolleary/pubsubclient

  //Define PINS ----------------------------------------------------------------
  #define switchOnBoardPin 0  //Pen waarop de onboard push button is aangesloten
  #define ledOnBoardPin    2          //Pen waarop de onboard LED is aangesloten
  #define touch5Pin       12      //Pen waarop touch5 electronica is aangesloten
  #define lightPin        13             //Pen waarop verlichting is aangesloten
  #define heaterPin       15              //Pen waarop verwarming is aangesloten
  #define ONE_WIRE_BUS    17                   //Aansluiting DS18B20 OneWire pin
  #define EEPROM_size     11       //Aantal bytes gereserveerd voor eigen opslag
  //#define SDA TWI       21    //Pen waarop intern de TWI logica is aangesloten
  //#define SCL TWI       22    //Pen waarop intern de TWI logica is aangesloten

  //Define VARIABLE EEPROM -----------------------------------------------------
  int           progHeater       = 0; //EEPROM(1)   1=on 2=uit 3=auto VERWARMING
  int           tempOn           = 0; //EEPROM(2)   Temp  verwarming aan relais1
  int           tempOff          = 0; //EEPROM(3)    Temp verwarming uit relais1
  int           progLed          = 0; //EEPROM(4)  1=on 2=uit 3=auto VERLICHTING
  int           ledOnHour        = 0; //EEPROM(5)       Schakel aan tijd relais2
  int           ledOffHour       = 0; //EEPROM(6)       Schakel uit tijd relais2
  int           interval         = 10; //EEPROM(7) Aantal seconden tussen meting

  //Define variables -----------------------------------------------------------
  const bool    AAN              = LOW;    //Om een makkelijke inversie te maken
  const bool    UIT              = HIGH;   //Om een makkelijke inversie te maken
  bool          ledOnBoardVal    = 0;            //Toggelt tussen aan en uit LED
  float         touchSensor      = 0;   //Welke waarde lezen we van touch sensor
  float         tempDS18B20      = 0;    //Sensor temperature in Celsius DS18B20
  float         tempPrevious     = 0;     //Laatst gemeten temperatuu in Celsius
  float         tempPrevious2    = 0;              //Vermijd heen en weer jumpen
  char          Temperatuur[8]   = "34.8";         //Format data publicatie MQTT
  unsigned long lastMsg          = 0; //Teller om de hoeveel millisec een meting
  bool          tmpBool          = 0;      //Gebruikt bij setrelais als geheugen
  bool          heaterStatus     = 1;     //LOW=on or HIGH=off relay1 VERWARMING
  bool          lightStatus      = 1;    //LOW=on or HIGH=off relay1 VERLICHTING
  int           uur              = 25;         //Uur voor berekening VERLICHTING
  int           graden           = 0;        //Graden voor berekening VERWARMING
  
  String        strTopic;               //Nodig om strings te kunnen samenvoegen
  char          topic[50];                                     //Nodig voor MQTT
  String        strPayload;             //Nodig om strings te kunnen samenvoegen
  char          payload[50];                                   //Nodig voor MQTT
  String        testTopic;              //Nodig om strings te kunnen samenvoegen
  char          deviceName[50];                                //Nodig voor MQTT

  //Initialize OBJECTS ---------------------------------------------------------
  Adafruit_7segment matrix = Adafruit_7segment();        //Initialiseer backpack
  OneWire oneWire(ONE_WIRE_BUS);  //Initialiseer DS18B20 Dallas oneWire protocol
  DS18B20 sensor(&oneWire);               //Initialiseer DS18B20 sensor software
  WiFiClient espClient;         //We maken een WiFi object met de naam espclient
  PubSubClient client(espClient);  //We maken een MQTT object met de naam client
  WiFiUDP ntpUDP;                               //Maak een streaming WiFi object
  NTPClient timeClient(ntpUDP, "europe.pool.ntp.org", 3600);   //Maak NTP object
//END OF PRECOMPILER OPTIONS ---------------------------------------------------


void setup() { //Setup runs once ***********************************************
  Serial.begin(115200);       //Nothing more needed for the Serial Monitor RS232
  while (!Serial);                //Wacht totdat de seriele poort is geactiveerd
  Serial.print("\n\nESP32 station ");       //Geef berichtje via seriele monitor
  Serial.println(deviceID);                 //Geef berichtje via seriele monitor
  Serial.println(__FILE__);                   //Welke sketch draait er eigenlijk
  Serial.print("DS18B20 Library version: "); //Geef berichtje op seriele monitor
  Serial.println(DS18B20_LIB_VERSION);        //Welke versie draait er eigenlijk
  pinMode(ledOnBoardPin, OUTPUT);       //Kaartje bevat op pin 2 een onboard LED
  pinMode(heaterPin, OUTPUT);                     //Verwarmingspin 12 is relais1
  digitalWrite(heaterPin, UIT);                   //Zet de verwarming direct uit
  pinMode(lightPin, OUTPUT);                     //Verlichtingspin 13 is relais2
  digitalWrite(lightPin, UIT);                   //Zet de verlichting direct uit

  //Start objects --------------------------------------------------------------
  matrix.begin(0x70);                                   //Geef het TWI adres mee
  matrix.setBrightness(1);                   //Zet de sterkte van het licht 1-16
  matrix.print(1);                          //Laat een nummer zien op LEDdisplay
  matrix.writeDisplay();                                //Doe de display updaten
  setup_wifi();                                  //Maak verbinding en start WiFi

  Serial.print("Start MQTT client ");        //Geef berichtje op seriele monitor
  client.setServer(mqttServer, 1883);        //Op welke PC draait de MQQT server
  client.setCallback(callback);              //Wat te doen als we iets ontvangen
  deviceID.toCharArray(deviceName, 12);                        //Nodig voor MQTT
  if (client.connect(deviceName, "", "")) {                      //Verbinding ok
  }else{                                                    //Verbinding mislukt
    Serial.println(" Connection failed ");   //Geef berichtje op seriele monitor
    reconnect();                    //Blijf proberen totdat we verbinding hebben
  }                                 //Nu hebben we verbinding met de MQTT server
  Serial.print("connected ");                //Geef berichtje op seriele monitor

  strTopic = "/2802ZS9/kantoor/" + deviceID + "/actuators/#"; //Callback setting !!
  strTopic.toCharArray(topic, 50);                      //Convert String to char !!
  boolean r = client.subscribe(topic);                //Create MQTT subscription !!
  
  Serial.println(" ");                       //Geef berichtje op seriele monitor
  Serial.print("subscribe to:");             //Geef berichtje op seriele monitor
  Serial.print(topic);                       //Geef berichtje op seriele monitor
  Serial.println("-");  
         
  Serial.print("subscribe ");                //Geef berichtje op seriele monitor
  Serial.println(r);                                 //1=geabbonneerd  0=mislukt

  strPayload = deviceID + " online";                           //Nodig voor MQTT !!
  strPayload.toCharArray(payload, 30);                         //Nodig voor MQTT !!
  r = client.publish("/Systeem", payload);                //Voor de statistieken !!

  EEPROM.begin(EEPROM_size); //Reserveer het EEPROM gebied in het flash geheugen
  //EEPROMfirstTime();                    //First time use, set values in EEPROM
  EEPROMreadData();                           //Read and define variables EEPROM

  timeClient.begin();                     //Het NTP uitlees object wordt gestart
  sensor.begin();                          //Start de DS18B20 temperatuur sensor
  //Test hardware and software -------------------------------------------------
  readTime();                    //Lees de tijd uit timer van de microcontroller
  Serial.println(" ");
  //testRelay();                           //Switches ON for 2 seconds the RELAY
  readSensors();         //Read sensors at timed intervals only and publish data  
} //End of setup ---------------------------------------------------------------







void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  if (!client.connected()) {  //Test of we nog verbonden zijn met de MQTT server
    reconnect();     //Als we niet meer verbonden zijn doe dan opnieuw verbinden
  } //End of                                            if (!client.connected())
  client.loop();                            //Voer MQTT uit, controleer callback
  long now = millis();     //Lees het aantal milliseconden sinds start programma
  if (now-lastMsg > interval*1000 or now-lastMsg < 0) { //Indien waar doe meting
    lastMsg = now;                       //Reset de tijd voor de volgende meting
    readSensors();       //Read sensors at timed intervals only and publish data
  } //End of                      if (now-lastMsg > interval or now-lastMsg < 0)
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER








void readSensors() { //Read sensors at timed intervals only ********************
  digitalWrite (ledOnBoardPin, 1);                   //Schakel de blauwe LED aan
  sensor.requestTemperatures();         //Zet de temperatuur sensor aan het werk
  while (!sensor.isConversionComplete());     //Wacht totdat de DS18B20 klaar is
  tempDS18B20 = sensor.getTempC() * 10;                       //Lees temperatuur
  tempDS18B20 = (floor (tempDS18B20))/10;      //Die honderdsten hebben geen zin
  graden = tempDS18B20; //Omzetten in een integer omd de verwarming te schakelen
  matrix.print(tempDS18B20,1);          //Laat de temperatuur zien op LEDdisplay
  matrix.writeDisplay();                                //Doe de display updaten
  if (tempDS18B20 != tempPrevious){                  //Ik meet een nieuwe waarde
    if (tempDS18B20 != tempPrevious2) {            //Vermijd heen en weer jumpen
      tempPrevious = tempDS18B20;                     //Stel de nieuwe waarde in
      tempPrevious2 = tempDS18B20;                    //Stel de nieuwe waarde in
      setRelay1();                       //Bereken en schakel relais1 VERWARMING
      dtostrf(tempDS18B20, 6, 1, Temperatuur);    //Leave room for large numbers
      strTopic = "/2802ZS9/kantoor/" + deviceID + "/sensors/ds1820/celcius/"; // !!
      strTopic.toCharArray(topic, 50);                  //Convert String to char !!
      if (!client.publish(topic, Temperatuur)) {
        Serial.println("geen MQTT data verzonden");        //Show activity RS232
      } //End of                                            if (!client.publish(
    } //End of                                 if (tempDS18B20 != tempPrevious2)
  } //End of                                    if (tempDS18B20 != tempPrevious)
  setRelay2();                          //Bereken en schakel relais2 VERLICHTING
  digitalWrite (ledOnBoardPin, 0);                   //Schakel de blauwe LED uit
} //Exit readSensors -----------------------------------------------------------




void setRelay1(){ //Bereken en schakel relais1 VERWARMING **********************
  tmpBool = heaterStatus;          //The same at the end? otherwise message MQTT
  switch (progHeater) {           //Relay1 program: 1=off 2=auto 3=on VERWARMING

    case 1:                                 //Programma = 1 = Zet VERWARMING aan
      heaterStatus = AAN;       //Status HIGH=off, LOW=on VERWARMINGSMAT RELAIS1
      break;              //End of Program = 1 = Set program  VERWARMINGSMAT AAN

    case 2:                                 //Programma = 2 = Zet VERWARMING uit
      heaterStatus = UIT;     //Status HIGH=off or LOW=on  VERWARMINGSMAT RELAY1
      break;              //End of Program = 2 = Set program  VERWARMINGSMAT UIT

    case 3:                             //Programma = 3 = Zet VERWARMING op auto
      if (graden < tempOn){                    //If treshold measurement TURN ON
        heaterStatus = AAN;         //Status HIGH=off or LOW=on HEATER ON RELAY1
      } //End of                                 If treshold measurement TURN ON
      if (graden > tempOff){                  //If treshold measurement TURN OFF
        heaterStatus = UIT;         //Status HIGH=off or LOW=on HEATER ON RELAY1
      } //End of                                If treshold measurement TURN OFF
      break;                 //End of Program = 3 = Set program COIL HEATER AUTO
  } //End of switch (progHeater)    Relay1 program: 1=off 2=auto 3=on VERWARMING

  if (tmpBool != heaterStatus){           //De verwarming moet worden geschakeld
    digitalWrite(heaterPin, heaterStatus);                     //Switches RELAY1
    strTopic = "/2802ZS9/kantoor/" + deviceID + "/actuators/verwarming/status/"; // !!
    strTopic.toCharArray(topic, 50);                    //Convert String to char !!
    if (heaterStatus) {                              //Schakel de verwarming uit
        if (!client.publish(topic, "uit")) {
        Serial.println("geen MQTT data verzonden");        //Show activity RS232
        } //End of if (!client.publish(
    }else{                                           //Schakel de verwarming aan
        if (!client.publish(topic, "aan")) {
        Serial.println("geen MQTT data verzonden");        //Show activity RS232
        } //End of if (!client.publish(
     } //End of if (heaterStatus)                          Schakel de verwarming
  } //End of if (tmpBool != heaterStatus    De verwarming moet worden geschakeld
} //Exit setRelay1 -------------------------------------------------------------





void setRelay2(){ //Bereken en schakel relais2 VERLICHTING *********************
  readTime();                    //Lees de tijd uit timer van de microcontroller
  Serial.print(" aan:");                    //Geef berichtje via seriele monitor
  Serial.print(ledOnHour);                  //Geef berichtje via seriele monitor
  Serial.print(" uit:");                    //Geef berichtje via seriele monitor
  Serial.println(ledOffHour);               //Geef berichtje via seriele monitor
  tmpBool = lightStatus;           //The same at the end? otherwise message MQTT
  switch (progLed) {             //VERLICHTING program: 1=off 2=auto 3=on RELAY2

    case 1:                           //Program = 1 = Set program VERLICHTING ON
      lightStatus = AAN;          //Status HIGH=off or LOW=on VERLICHTING RELAY2
      break; //Case 1            End of Program = 1 = Set program VERLICHTING ON

    case 2:                     //Program = 2 = Set program GROEIVERLICHTING OFF
      lightStatus = UIT;     //Status HIGH=off or LOW=on GROEIVERLICHTING RELAY2
      break; //Case 2      End of Program = 2 = Set program GROEIVERLICHTING OFF

    case 3:                         //Program = 3 = Set program VERLICHTING AUTO
      if (uur > (ledOnHour-1) && uur < (ledOffHour)){                       //ON
         lightStatus = AAN;         //Switch ON , HIGH=off LOW=on VERLICHTING ON
      } //End of  if (currenthour > (starthours-1) && currenthour <(finishhours)
      
      if (uur < ledOnHour){                         //Too early, VERLICHTING OFF
         lightStatus = UIT;       //Switch OFF , HIGH=off LOW=on VERLICHTING OFF
      } //End of if (currenthour < starthours){     //Too early, VERLICHTING OFF

      if (uur >= ledOffHour){                        //Too late, VERLICHTING OFF
         lightStatus = UIT;       //Switch OFF , HIGH=off LOW=on VERLICHTING OFF
      } //End of if (currenthour > finishhours)        Too late, VERLICHTING OFF
    break; //Case 3            End of Program = 3 = Set program VERLICHTING AUTO
  } //End of switch (progLed)      VERLICHTING program: 1=off 2=auto 3=on RELAY2

  if (tmpBool != lightStatus){           //De verlichting moet worden geschakeld
    digitalWrite(lightPin, lightStatus);        //Schakel relais2 zoals berekend
    strTopic = "/2802ZS9/kantoor/" + deviceID+ "/actuators/verlichting/status/"; // !!
    strTopic.toCharArray(topic, 50);                    //Convert String to char !!
    if (lightStatus) {                              //Schakel de verlichting uit
        if (!client.publish(topic, "uit")) {
        Serial.println("geen MQTT data verzonden");  //Geef berichtje op monitor
        } //End of if (!client.publish(
    }else{
        if (!client.publish(topic, "aan")) {
        Serial.println("geen MQTT data verzonden");  //Geef berichtje op monitor
        } //End of if (!client.publish(
    } //End of if (lightStatus)                           Schakel de verlichting
  } //End of if (tmpBool != lightStatus    De verlichting moet worden geschakeld
} //Exit setRelay2 -------------------------------------------------------------






void callback(char* subject, byte* payloadreceived, unsigned int length) {//MQTT
  strPayload = "";                    //Leegmaken anders wordt hij wel heel lang
  for (int i=0;i<length;i++) {                          //Haal de payload binnen
    strPayload += (char)payloadreceived[i];     //Dit moet helaas byte voor byte
  } //End of for (int i=0;i<length;i++)                   Haal de payload binnen
  strTopic = subject;                              //Omzetten van char in String
  Serial.print("Message arrived on topic:");         //Geef berichtje op monitor
  Serial.print(strTopic);                   //Geef berichtje via seriele monitor
  Serial.print(":  Payload:");              //Geef berichtje via seriele monitor
  Serial.print(strPayload);                 //Geef berichtje via seriele monitor
  Serial.print("-");                        //Geef berichtje via seriele monitor
  Serial.println(length);                   //Geef berichtje via seriele monitor
  
  testTopic = "/2802ZS9/kantoor/" +deviceID+ "/actuators/verlichting/opdracht/"; //!!
  if (strTopic == testTopic) {
    Serial.println("Opdracht herkend");              //Geef berichtje op monitor
    if (strPayload == "aan"){                              //1 = VERLICHTING AAN
      progLed = 1;                             //0=unknown, 1=aan, 2=uit, 3=auto
      EEPROM.write(4, 1);                             //Write 1 byte into eeprom
      EEPROM.commit();      //Nodig op ESP32 omdat het geen EEPROM is maar flash
      Serial.println("Opdracht: verlichting aan");   //Geef berichtje op monitor
    } //End of                                            if (opdracht == "aan")
    if (strPayload == "uit"){                              //2 = VERLICHTING UIT
      progLed = 2;                             //0=unknown, 1=aan, 2=uit, 3=auto
      EEPROM.write(4, 2);                             //Write 1 byte into eeprom
      EEPROM.commit();      //Nodig op ESP32 omdat het geen EEPROM is maar flash
      Serial.println("Opdracht: verlichting uit");   //Geef berichtje op monitor
    } //End of                                            if (opdracht == "uit")
    if (strPayload=="auto"){                              //3 = VERLICHTING AUTO
      progLed = 3;                             //0=unknown, 1=aan, 2=uit, 3=auto
      EEPROM.write(4, 3);                             //Write 1 byte into eeprom
      EEPROM.commit();      //Nodig op ESP32 omdat het geen EEPROM is maar flash
      Serial.println("Opdracht: verlichting automatisch");      //Geef berichtje
    } //End of                                           if (opdracht == "auto")
    setRelay2();                        //Bereken en schakel relais2 VERLICHTING
  } //End of                                                        if (topic ==


  testTopic="/2802ZS9/kantoor/"+deviceID+"/actuators/verlichting/aanschakeltijd/"; //!!
  if (strTopic == testTopic) {
    ledOnHour = strPayload.toInt();          //Translate the payload into a byte
    EEPROM.write(5, ledOnHour);                       //Write 1 byte into eeprom
    EEPROM.commit();        //Nodig op ESP32 omdat het geen EEPROM is maar flash
    Serial.print("Verlichting aanschakelen om ");    //Geef berichtje op monitor
    Serial.print(ledOnHour);                //Geef berichtje via seriele monitor
    Serial.println(" uur");                 //Geef berichtje via seriele monitor
    dtostrf(ledOnHour, 4, 0, payload);        //Leave room for too large numbers
    strTopic = "/2802ZS9/kantoor/" +deviceID+ "/actuators/verlichting/tijdaan/"; // !!
    strTopic.toCharArray(topic, 50);                    //Convert String to char !!
    if (!client.publish(topic, payload)) {
      Serial.println("geen MQTT data verzonden");    //Geef berichtje op monitor
    } //End of                                              if (!client.publish(
    setRelay2();                        //Bereken en schakel relais2 VERLICHTING
  } //End of                                                        if (topic ==

 
  testTopic="/2802ZS9/kantoor/"+deviceID+"/actuators/verlichting/uitschakeltijd/"; //!!
  if (strTopic == testTopic) {
    ledOffHour = strPayload.toInt();         //Translate the payload into a byte
    EEPROM.write(6, ledOffHour);                      //Write 1 byte into eeprom
    EEPROM.commit();        //Nodig op ESP32 omdat het geen EEPROM is maar flash
    Serial.print("Verlichting uitschakelen om ");    //Geef berichtje op monitor
    Serial.print(ledOffHour);               //Geef berichtje via seriele monitor
    Serial.println(" uur");                 //Geef berichtje via seriele monitor
    dtostrf(ledOffHour, 4, 0, payload);       //Leave room for too large numbers
    strTopic = "/2802ZS9/kantoor/" +deviceID+ "/actuators/verlichting/tijduit/"; // !!
    strTopic.toCharArray(topic, 50);                    //Convert String to char !!
    if (!client.publish(topic, payload)) {
      Serial.println("geen MQTT data verzonden");          //Show activity RS232
    } //End of                                              if (!client.publish(
    setRelay2();                        //Bereken en schakel relais2 VERLICHTING
  } //End of                                                        if (topic ==


  testTopic= "/2802ZS9/kantoor/" + deviceID + "/actuators/verwarming/opdracht/"; //!!
  if (strTopic == testTopic) {
    if (strPayload == "aan"){                               //1 = VERWARMING AAN
      progHeater = 1;                          //0=unknown, 1=aan, 2=uit, 3=auto
      EEPROM.write(1, 1);                             //Write 1 byte into eeprom
      EEPROM.commit();      //Nodig op ESP32 omdat het geen EEPROM is maar flash
      Serial.println("Opdracht: verwarming aan");    //Geef berichtje op monitor
    } //End of                                            if (opdracht == "aan")
    if (strPayload=="uit"){                                 //2 = VERWARMING UIT
      progHeater = 2;                          //0=unknown, 1=aan, 2=uit, 3=auto
      EEPROM.write(1, 2);                             //Write 1 byte into eeprom
      EEPROM.commit();      //Nodig op ESP32 omdat het geen EEPROM is maar flash
      Serial.println("Opdracht: verwarming uit");    //Geef berichtje op monitor
    } //End of                                            if (opdracht == "aan")
    if (strPayload=="auto"){                               //3 = VERWARMING AUTO
      progHeater = 3;                          //0=unknown, 1=aan, 2=uit, 3=auto
      EEPROM.write(1, 3);                             //Write 1 byte into eeprom
      EEPROM.commit();      //Nodig op ESP32 omdat het geen EEPROM is maar flash
      Serial.println("Opdracht: verwarming automatisch"); ;     //Geef berichtje
    } //End of                                           if (opdracht == "auto")
    setRelay1();                         //Bereken en schakel relais1 VERWARMING
  } //End of                                                        if (topic ==

 
  testTopic="/2802ZS9/kantoor/"+deviceID+"/actuators/verwarming/aanschakeltemp/"; //!!
  if (strTopic == testTopic) {
    tempOn = strPayload.toInt();             //Translate the payload into a byte
    EEPROM.write(2, tempOn);                          //Write 1 byte into eeprom
    EEPROM.commit();        //Nodig op ESP32 omdat het geen EEPROM is maar flash
    Serial.print("Verwarming aanschakelen bij <= "); //Geef berichtje op monitor
    Serial.print(tempOn);                   //Geef berichtje via seriele monitor
    Serial.println(" graden Celcius");      //Geef berichtje via seriele monitor
    dtostrf(tempOn, 6, 1, payload);           //Leave room for too large numbers
    strTopic = "/2802ZS9/kantoor/" +deviceID + "/actuators/verwarming/tempaan/"; // !!
    strTopic.toCharArray(topic, 50);                    //Convert String to char !!
    if (!client.publish(topic, payload)) {
      Serial.println("geen MQTT data verzonden");    //Geef berichtje op monitor
    } //End of                                              if (!client.publish(
    setRelay1();                         //Bereken en schakel relais1 VERWARMING
  } //End of                                                        if (topic ==


  testTopic="/2802ZS9/kantoor/"+deviceID+"/actuators/verwarming/uitschakeltemp/"; //!!
  if (strTopic == testTopic) {
    tempOff = strPayload.toInt();            //Translate the payload into a byte
    EEPROM.write(3, tempOff);                         //Write 1 byte into eeprom
    EEPROM.commit();        //Nodig op ESP32 omdat het geen EEPROM is maar flash
    Serial.print("Verwarming uitschakelen bij => "); //Geef berichtje op monitor
    Serial.print(tempOff);                  //Geef berichtje via seriele monitor
    Serial.println(" graden");              //Geef berichtje via seriele monitor
    dtostrf(tempOff, 6, 1, payload);          //Leave room for too large numbers
    strTopic = "/2802ZS9/kantoor/" +deviceID + "/actuators/verwarming/tempuit/"; // !!
    strTopic.toCharArray(topic, 50);                    //Convert String to char !!
    if (!client.publish(topic, payload)) {
      Serial.println("geen MQTT data verzonden");    //Geef berichtje op monitor
    } //End of                                              if (!client.publish(
    setRelay1();                         //Bereken en schakel relais1 VERWARMING
  } //End of                                                        if (topic ==

} //Exit callback --------------------------------------------------------------


void readTime(){ //Lees de tijd uit timer van de microcontroller ***************
  uur = 25;         //Enkel indien het uitlezen mislukt is kan het 25 uur worden
  timeClient.update();
  uur = timeClient.getHours();
  Serial.print(timeClient.getFormattedTime());
  Serial.print(" Uur:");
  Serial.print(uur);  
} //End of void readTime() -----------------------------------------------------


void reconnect() {  //Maak verbinding en start MQTT ****************************
  int counter = 0;   //Tel hoevaak we moeten proberen en laat zien op LEDdisplay
  while (WiFi.status() != WL_CONNECTED) {  //Indien verbinding niet is bevestigd
    WiFi.begin(ssid, password);       //We start by connecting to a WiFi network
    delay(2000);                                   //Wacht dan een halve seconde
    Serial.print(".");                      //Geef berichtje via seriele monitor
    matrix.print(counter);                 //Laat de pogingen zien op LEDdisplay
    matrix.writeDisplay();                              //Doe de display updaten
    counter++;                                           //Counter = counter + 1
  } //End of while                               (WiFi.status() != WL_CONNECTED)

  while (!client.connected()) {                   //Loop until we're reconnected
    Serial.print("Attempting MQTT connection...");   //Geef berichtje op monitor
    if (client.connect("ESP8266Client")) {                  //Attempt to connect
      Serial.println("connected");                   //Geef berichtje op monitor
      strTopic = "/2802ZS9/kantoor/" + deviceID + "/actuators/#";     //Callback
      strTopic.toCharArray(topic, 50);                  //Convert String to char
      boolean r = client.subscribe(topic);            //Create MQTT subscription
    } else {                                          //Herverbinden niet gelukt
      Serial.print("failed, rc=");                   //Geef berichtje op monitor
      Serial.print(client.state());                  //Geef berichtje op monitor
      Serial.println(" try again in 5 seconds");     //Geef berichtje op monitor
      delay(5000);                              //Wait 5 seconds before retrying
    } //End of                              if (client.connect("ESP8266Client"))
  } //End of                                         while (!client.connected())
} //Exit reconnect -------------------------------------------------------------


void setup_wifi() { //Maak verbinding en start WiFi ****************************
  Serial.print("\nVerbinden met ");         //Geef berichtje via seriele monitor
  Serial.println(ssid);                     //Geef berichtje via seriele monitor
  WiFi.begin(ssid, password);         //We start by connecting to a WiFi network
  int counter = 0;   //Tel hoevaak we moeten proberen en laat zien op LEDdisplay
  while (WiFi.status() != WL_CONNECTED) {  //Indien verbinding niet is bevestigd
    delay(2000);                                   //Wacht dan een halve seconde
    Serial.print(".");                      //Geef berichtje via seriele monitor
    matrix.print(counter);                 //Laat de pogingen zien op LEDdisplay
    matrix.writeDisplay();                              //Doe de display updaten
    counter++;                                           //Counter = counter + 1
  } //End of while                               (WiFi.status() != WL_CONNECTED)
  Serial.print("WiFi verbonden IP address:");        //Geef berichtje op monitor
  Serial.println(WiFi.localIP());           //Geef berichtje via seriele monitor
} //Exit setup_wifi ------------------------------------------------------------


void EEPROMreadData() { //Read and define variables EEPROM *********************
  progHeater   = EEPROM.read(1);                  //1=off 2=auto 3=on VERWARMING
  tempOn       = EEPROM.read(2);                  //Temp  verwarming aan relais1
  tempOff      = EEPROM.read(3);                   //Temp verwarming uit relais1
  progLed      = EEPROM.read(4);                 //1=off 2=auto 3=on VERLICHTING
  ledOnHour    = EEPROM.read(5);                      //Schakel aan tijd relais2
  ledOffHour   = EEPROM.read(6);                      //Schakel uit tijd relais2
  interval     = EEPROM.read(7);                    //Interval metingen seconden
} //Exit EEPROMreadData --------------------------------------------------------


void EEPROMfirstTime() { //First time use, set values in EEPROM ****************
    Serial.println("Reset EEPROM data");             //Geef berichtje op monitor
  //             0000        Never use this memory location to be AVR compatible
  EEPROM.write(1,   3);                //progHeater 1=on 2=uit 3=auto VERWARMING
  EEPROM.commit();          //Nodig op ESP32 omdat het geen EEPROM is maar flash
  EEPROM.write(2,  16);                           //Temp  verwarming aan relais1
  EEPROM.commit();          //Nodig op ESP32 omdat het geen EEPROM is maar flash
  EEPROM.write(3,  18);                            //Temp verwarming uit relais1
  EEPROM.commit();          //Nodig op ESP32 omdat het geen EEPROM is maar flash
  EEPROM.write(4,   3);                  //progLed 1=on 2=uit 3=auto VERLICHTING
  EEPROM.commit();          //Nodig op ESP32 omdat het geen EEPROM is maar flash
  EEPROM.write(5,   9);                               //Schakel aan tijd relais2
  EEPROM.commit();          //Nodig op ESP32 omdat het geen EEPROM is maar flash
  EEPROM.write(6,  15);                               //Schakel uit tijd relais2
  EEPROM.commit();          //Nodig op ESP32 omdat het geen EEPROM is maar flash
  EEPROM.write(7,  30);                             //Interval metingen seconden
  EEPROM.commit();          //Nodig op ESP32 omdat het geen EEPROM is maar flash
} //Exit EEPROMfirstTime -------------------------------------------------------


void testRelay(){ //Switches ON for 2 seconds both RELAY ***********************
  digitalWrite(heaterPin, AAN);                         //Switches ON the RELAY1
  delay (2000);                                             //Wait for 2 seconds
  digitalWrite(heaterPin, UIT);                        //Switches OFF the RELAY1
  digitalWrite(lightPin, AAN);                          //Switches ON the RELAY2
  delay (2000);                                             //Wait for 2 seconds
  digitalWrite(lightPin, UIT);                         //Switches OFF the RELAY2
} //End of testRelay(){ Switches ON for 2 seconds the RELAY --------------------


void toggle_ledOnBoard(void){ //Togglet de ledOnBoardVal van ledOnBoard ********
  ledOnBoardVal = !ledOnBoardVal;                                 //Toggle value
  digitalWrite(ledOnBoardPin, ledOnBoardVal);           //Set boards onboard LED
} //Exit toggle_ledOnBoard -----------------------------------------------------


void close_WiFi(void){ //Disconnect WiFi as it's no longer needed **************
  WiFi.disconnect(true);                                           //Stop object
  WiFi.mode(WIFI_OFF);                                       //Schakel power uit
} //Exit close_WiFi ------------------------------------------------------------


////////////////////////////////////////////////////////////////////////////////
// PIN ALLOCATIONS TABLE HELTEC WIFILORA 32 V1                                //
// GPIO - Function    - External Connection                              FUNC //
//                                                                            //
//    0 - Push button - Internally connected                          GPO PPG //
//    2 - ADC2_2      - HSPI-WP ONBOARD LED                               LED //
//    4 - ADC2_0      - HSPI-HD TOUCH0                               GPIO ADC //
//    5 - LoRa_Sck    - VSPI-CSO Input is LoRa_Sck                    GPO SPI //
//   12 - ADC2_5      - TOUCH5                                       GPIO ADC //
//   13 - ADC2_4      - TOUCH4                                       GPIO ADC //
//   15 - ADC2_3      - HSPI-CSO TOUCH3                              GPIO ADC //
//   17 - ADC2_4      - U2_TXD                                       GPIO TXD //
//   18 - LoRa_Cs     - VSPI-CLK Input is LoRa_Cs                     GPO SPI //
//   19 - LoRa_MiSO   - VSPI-Q Input is LoRa_MiSo U0_CTS              GPO SPI //
//   21 - SDA         - Input is Vext control                         GPO TWI //
//   22 - SCL         - VSPI-WP U0_RTS                               GPIO TWI //
//   23 - V_SPI_D     -                                               GPO SPI //
//   32 - XTAL32      - INPUT ONLY                                        ADC //
//   33 - XTAL32      - INPUT ONLY                                        ADC //
//   36 - ADC1_0      - INPUT ONLY                                        ADC //
//   37 - ADC1_1      - INPUT ONLY                                        ADC //
//   38 - ADC1_2      - INPUT ONLY                                        ADC //
//   39 - ADC1_3      - INPUT ONLY                                        ADC //
////////////////////////////////////////////////////////////////////////////////
