////////////////////////////////////////////////////////////////////////////////
// Naam:       HT32_LEDdisplay.ino                                            //
//             http://robotigs.com/robots/includes/parts.php?idpart=369       //
//                                                                            //
// Created by: HARB rboek2@gmail.com december 2020 GPL copyrights             //
// Origineel:  https://randomnerdtutorials.com (zie onder)                    //
// Platform:   Helltec WifiLoRa 32                                            //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
// - LED display 4 * 7 segmenten met punten en dubble punt                    //
//            http://robotigs.nl/robots/includes/parts.php?idpart=356         //
//                                                                            //
// As inputs the following modules are mounted:                               //
//                                                                            //
// For communications and statistics are mounted:                             //
// - Standard Serial Monitor output                                           //
//            http://robotigs.nl/robots/includes/parts.php?idpart=43          //
////////////////////////////////////////////////////////////////////////////////

// SET PRECOMPILER OPTIONS *****************************************************
  //Define the needed header files for the precompiler, no charge if not used --
  #include "HT16K33.h"                 // https://github.com/RobTillaart/HT16K33

  //Define PINS ----------------------------------------------------------------
  #define switchOnBoardPin 0  //Pen waarop de onboard push button is aangesloten
  #define ledOnBoardPin    2          //Pen waarop de onboard LED is aangesloten
  #define touch5Pin       12      //Pen waarop touch5 electronica is aangesloten
  //#define SDA TWI       21    //Pen waarop intern de TWI logica is aangesloten
  //#define SCL TWI       22    //Pen waarop intern de TWI logica is aangesloten

  //Define EEPROM variables ----------------------------------------------------
  //Define DATABASE VARIABLES --------------------------------------------------
  //Define variables -----------------------------------------------------------
  bool ledOnBoardVal = 0;        //Toggelt tussen 0 en 1 om LED te schakelen LED
  float touchSensor  = 0;          //Welke waarde lezen we van onze touch sensor
  //Initialize OBJECTS ---------------------------------------------------------
  HT16K33 seg(0x70);   //Initialiseer backpack software op het default TWI adres
//END OF PRECOMPILER OPTIONS ---------------------------------------------------




void setup() { //Setup runs once ***********************************************
  Serial.begin(115200);       //Nothing more needed for the Serial Monitor RS232
  while (!Serial);                //Wacht totdat de seriele poort is geactiveerd
  Serial.println("\n\nESP32 Display Test"); //Geef berichtje via seriele monitor
  Serial.println(__FILE__);                   //Welke sketch draait er eigenlijk
  pinMode(ledOnBoardPin, OUTPUT);                //Board contains an onboard LED

  //Start objects --------------------------------------------------------------
  seg.begin();                             //Start backpack software LED display
  Wire.setClock(100000);    //Dit is lekker rap maar niet werkzaam voor alle TWI
  seg.displayOn();                                  //Schakel de LED display aan

  //Test hardware and software -------------------------------------------------
} //End of setup ---------------------------------------------------------------







void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  digitalWrite(ledOnBoardPin,!digitalRead(switchOnBoardPin)); //PPG schakelt LED
  touchSensor = touchRead(touch5Pin);                      //Get value of Touch5
  seg.displayFloat(touchSensor);             //Laat de waarde zien op LEDdisplay
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER








void toggle_ledOnBoard(void){ //Togglet de ledOnBoardVal van ledOnBoard ********
  ledOnBoardVal = !ledOnBoardVal;                                 //Toggle value
  digitalWrite(ledOnBoardPin, ledOnBoardVal);           //Set boards onboard LED
} //Exit toggle_ledOnBoard -----------------------------------------------------



////////////////////////////////////////////////////////////////////////////////
// PIN ALLOCATIONS TABLE HELTEC WIFILORA 32 V1                                //
// GPIO - Function    - External Connection                              FUNC //
//                                                                            //
//    0 - Push button - Internally connected                          GPO PPG //
//    2 - ADC2_2      - HSPI-WP ONBOARD LED                               LED //
//    4 - ADC2_0      - HSPI-HD TOUCH0                               GPIO ADC //
//    5 - LoRa_Sck    - VSPI-CSO Input is LoRa_Sck                    GPO SPI //
//   12 - ADC2_5      - TOUCH5                                       GPIO ADC //
//   13 - ADC2_4      - TOUCH4                                       GPIO ADC //
//   15 - ADC2_3      - HSPI-CSO TOUCH3                              GPIO ADC //
//   17 - ADC2_4      - U2_TXD                                       GPIO TXD //
//   18 - LoRa_Cs     - VSPI-CLK Input is LoRa_Cs                     GPO SPI //
//   19 - LoRa_MiSO   - VSPI-Q Input is LoRa_MiSo U0_CTS              GPO SPI //
//   21 - SDA         - Input is Vext control                         GPO TWI //
//   22 - SCL         - VSPI-WP U0_RTS                               GPIO TWI //
//   23 - V_SPI_D     -                                               GPO SPI //
//   32 - XTAL32      - INPUT ONLY                                        ADC //
//   33 - XTAL32      - INPUT ONLY                                        ADC //
//   36 - ADC1_0      - INPUT ONLY                                        ADC //
//   37 - ADC1_1      - INPUT ONLY                                        ADC //
//   38 - ADC1_2      - INPUT ONLY                                        ADC //
//   39 - ADC1_3      - INPUT ONLY                                        ADC //
////////////////////////////////////////////////////////////////////////////////
