////////////////////////////////////////////////////////////////////////////////
// Naam:       HT32_PWM.ino                                                   //
//             http://robotigs.nl/robots/includes/bots.php?idbot=17           //
//                                                                            //
// Created by: HARB rboek2@gmail.com januari 2021 GPL copyrights              //
// Origineel:  https://randomnerdtutorials.com (zie onder)                    //
// Platform:   Helltec WifiLoRa 32                                            //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
// - Standard Onboard LED                                                     //
//           http://robotigs.nl/robots/includes/parts.php?idpart=185          //
//                                                                            //
// As inputs the following modules are mounted:                               //
//                                                                            //
// For communications and statistics are mounted:                             //
// - Standard Serial Monitor output                                           //
//            http://robotigs.nl/robots/includes/parts.php?idpart=43          //
////////////////////////////////////////////////////////////////////////////////

// SET PRECOMPILER OPTIONS *****************************************************

  //Define PINS ----------------------------------------------------------------
  #define ledOnBoardPin    2          //Pen waarop de onboard LED is aangesloten

  //Define VARIABLE EEPROM -----------------------------------------------------
  //Define VARIABLE SETTINGS ---------------------------------------------------
  const int freq = 5000;                                //Setting PWM properties
  const int ledChannel = 0;
  const int resolution = 8;

  //Define variables -----------------------------------------------------------
  //Initialize OBJECTS ---------------------------------------------------------
//END OF PRECOMPILER OPTIONS ---------------------------------------------------


void setup() { //Setup runs once ***********************************************
  Serial.begin(115200);       //Nothing more needed for the Serial Monitor RS232
  while (!Serial);                //Wacht totdat de seriele poort is geactiveerd
  Serial.println("\n\nESP32 Couveuse1_1");  //Geef berichtje via seriele monitor
  Serial.println(__FILE__);                   //Welke sketch draait er eigenlijk
  ledcSetup(ledChannel, freq, resolution);  //Configure LED PWM functionalitites
  ledcAttachPin(ledOnBoardPin, ledChannel);     //Attach the channel to the GPIO
  //Start objects --------------------------------------------------------------
  //Test hardware and software -------------------------------------------------
} //End of setup ---------------------------------------------------------------


void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  for(int dutyCycle = 0; dutyCycle <= 255; dutyCycle++){   //Increase brightness
    ledcWrite(ledChannel, dutyCycle);     //Changing the LED brightness with PWM
    delay(10);
  }

  for(int dutyCycle = 255; dutyCycle >= 0; dutyCycle--){  // decrease brightness
    ledcWrite(ledChannel, dutyCycle);     //Changing the LED brightness with PWM
    delay(10);
  }
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER




////////////////////////////////////////////////////////////////////////////////
// PIN ALLOCATIONS TABLE HELTEC WIFILORA 32 V1                                //
// GPIO - Function    - External Connection                              FUNC //
//                                                                            //
//    0 - Push button - Internally connected                          GPO PPG //
//    2 - ADC2_2      - HSPI-WP ONBOARD LED                               LED //
//    4 - ADC2_0      - HSPI-HD TOUCH0                               GPIO ADC //
//    5 - LoRa_Sck    - VSPI-CSO Input is LoRa_Sck                    GPO SPI //
//   12 - ADC2_5      - TOUCH5                                       GPIO ADC //
//   13 - ADC2_4      - TOUCH4                                       GPIO ADC //
//   15 - ADC2_3      - HSPI-CSO TOUCH3                              GPIO ADC //
//   17 - ADC2_4      - U2_TXD                                       GPIO TXD //
//   18 - LoRa_Cs     - VSPI-CLK Input is LoRa_Cs                     GPO SPI //
//   19 - LoRa_MiSO   - VSPI-Q Input is LoRa_MiSo U0_CTS              GPO SPI //
//   21 - SDA         - Input is Vext control                         GPO TWI //
//   22 - SCL         - VSPI-WP U0_RTS                               GPIO TWI //
//   23 - V_SPI_D     -                                               GPO SPI //
//   32 - XTAL32      - INPUT ONLY                                        ADC //
//   33 - XTAL32      - INPUT ONLY                                        ADC //
//   36 - ADC1_0      - INPUT ONLY                                        ADC //
//   37 - ADC1_1      - INPUT ONLY                                        ADC //
//   38 - ADC1_2      - INPUT ONLY                                        ADC //
//   39 - ADC1_3      - INPUT ONLY                                        ADC //
////////////////////////////////////////////////////////////////////////////////
