////////////////////////////////////////////////////////////////////////////////
// Naam:       HT32_Touch.ino                                                 //
//             http://robotigs.com/robots/includes/parts.php?idpart=113#rnt   //
//                                                                            //
// Created by: HARB rboek2@gmail.com december 2020 GPL copyrights             //
// Origineel:  https://randomnerdtutorials.com (zie onder)                    //
// Platform:   Helltec WifiLoRa 32                                            //
////////////////////////////////////////////////////////////////////////////////
// As outputs the following modules are mounted:                              //
// - Oled schermpje ,monochroom 128x64                                        //
//            http://robotigs.nl/robots/includes/parts.php?idpart=43          //
//                                                                            //
// As inputs the following modules are mounted:                               //
//                                                                            //
// For communications and statistics are mounted:                             //
// - Standard Serial Monitor output                                           //
//            http://robotigs.nl/robots/includes/parts.php?idpart=43          //
////////////////////////////////////////////////////////////////////////////////

// SET PRECOMPILER OPTIONS *****************************************************
  //Define the needed header files for the precompiler, no charge if not used --
  //Define PINS ----------------------------------------------------------------
  #define ledOnBoardPin   2           //Pen waarop de onboard LED is aangesloten
  #define touch5Pin      12       //Pen waarop touch5 electronica is aangesloten
  //Define EEPROM variables ----------------------------------------------------
  //Define DATABASE VARIABLES --------------------------------------------------
  //Define variables -----------------------------------------------------------
  bool ledOnBoardVal = 0;        //Toggelt tussen 0 en 1 om LED te schakelen LED
  //Initialize OBJECTS ---------------------------------------------------------
//END OF PRECOMPILER OPTIONS ---------------------------------------------------




void setup() { //Setup runs once ***********************************************
  Serial.begin(115200);       //Nothing more needed for the Serial Monitor RS232
  while (!Serial);                //Wacht totdat de seriele poort is geactiveerd
  Serial.println("ESP32 Touch Test");    //Geef berichtje via de seriele monitor
  pinMode(ledOnBoardPin, OUTPUT);                //Board contains an onboard LED
  //Start objects --------------------------------------------------------------
  //Test hardware and software -------------------------------------------------
} //End of setup ---------------------------------------------------------------





void loop() { //KEEP ON RUNNING THIS LOOP FOREVER  *****************************
  Serial.println(touchRead(touch5Pin));                    //Get value of Touch5
  digitalWrite(ledOnBoardPin,!touchRead(0));    //Schakel blauwe LED volgens PPG
  delay(100);                       //Houdt de seriele monitor enigzins leesbaar
} //End of void loop() ----------------------- KEEP ON RUNNING THIS LOOP FOREVER



void toggle_ledOnBoard(void){ //Togglet de ledOnBoardVal van ledOnBoard ********
  ledOnBoardVal = !ledOnBoardVal;                                 //Toggle value
  digitalWrite(ledOnBoardPin, ledOnBoardVal);           //Set boards onboard LED
} //Exit toggle_ledOnBoard -----------------------------------------------------



////////////////////////////////////////////////////////////////////////////////
// PIN ALLOCATIONS TABLE HELTEC WIFILORA 32 V1                                //
// GPIO - Function    - External Connection                              FUNC //
//                                                                            //
//    0 - Push button - Internally connected                          GPO PPG //
//    2 - ADC2_2      - HSPI-WP ONBOARD LED                               LED //
//    4 - ADC2_0      - HSPI-HD TOUCH0                               GPIO ADC //
//    5 - LoRa_Sck    - VSPI-CSO Input is LoRa_Sck                    GPO SPI //
//   12 - ADC2_5      - TOUCH5                                       GPIO ADC //
//   13 - ADC2_4      - TOUCH4                                       GPIO ADC //
//   15 - ADC2_3      - HSPI-CSO TOUCH3                              GPIO ADC //
//   17 - ADC2_4      - U2_TXD                                       GPIO TXD //
//   18 - LoRa_Cs     - VSPI-CLK Input is LoRa_Cs                     GPO SPI //
//   19 - LoRa_MiSO   - VSPI-Q Input is LoRa_MiSo U0_CTS              GPO SPI //
//   21 - SDA         - Input is Vext control                         GPO TWI //
//   22 - SCL         - VSPI-WP U0_RTS                               GPIO TWI //
//   23 - V_SPI_D     -                                               GPO SPI //
//   32 - XTAL32      - INPUT ONLY                                        ADC //
//   33 - XTAL32      - INPUT ONLY                                        ADC //
//   36 - ADC1_0      - INPUT ONLY                                        ADC //
//   37 - ADC1_1      - INPUT ONLY                                        ADC //
//   38 - ADC1_2      - INPUT ONLY                                        ADC //
//   39 - ADC1_3      - INPUT ONLY                                        ADC //
////////////////////////////////////////////////////////////////////////////////
